package com.almostreliable.unified;

import com.almostreliable.unified.api.StoneStrataHandler;
import com.almostreliable.unified.config.Config;
import com.almostreliable.unified.config.UnifyConfig;
import com.almostreliable.unified.utils.ReplacementMap;
import com.almostreliable.unified.utils.TagMap;
import com.almostreliable.unified.utils.TagOwnerships;
import com.almostreliable.unified.utils.UnifyTag;
import com.google.gson.JsonElement;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

// TODO: Implement sync, so it's not just a fallback
public class AlmostUnifiedFallbackRuntime implements AlmostUnifiedRuntime {

    @Nullable private static AlmostUnifiedFallbackRuntime INSTANCE;

    @Nullable private UnifyConfig unifyConfig;
    @Nullable private TagMap<class_1792> filteredTagMap;
    @Nullable private ReplacementMap replacementMap;

    public static AlmostUnifiedFallbackRuntime getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AlmostUnifiedFallbackRuntime();
            INSTANCE.reload();
        }

        return INSTANCE;
    }

    public void reload() {
        unifyConfig = null;
        filteredTagMap = null;
        replacementMap = null;
        build();
    }

    private void build() {
        unifyConfig = Config.load(UnifyConfig.NAME, new UnifyConfig.Serializer());
        Set<UnifyTag<class_1792>> unifyTags = unifyConfig.bakeTags();
        filteredTagMap = TagMap.create(unifyTags).filtered($ -> true, unifyConfig::includeItem);
        StoneStrataHandler stoneStrataHandler = createStoneStrataHandler(unifyConfig);
        TagOwnerships tagOwnerships = new TagOwnerships(unifyTags, unifyConfig.getTagOwnerships());
        replacementMap = new ReplacementMap(unifyConfig, filteredTagMap, stoneStrataHandler, tagOwnerships);
    }

    private static StoneStrataHandler createStoneStrataHandler(UnifyConfig config) {
        Set<UnifyTag<class_1792>> stoneStrataTags = AlmostUnifiedPlatform.INSTANCE.getStoneStrataTags(config.getStoneStrata());
        TagMap<class_1792> stoneStrataTagMap = TagMap.create(stoneStrataTags);
        return StoneStrataHandler.create(config.getStoneStrata(), stoneStrataTags, stoneStrataTagMap);
    }

    @Override
    public void run(Map<class_2960, JsonElement> recipes, boolean skipClientTracking) {
        // no-op
    }

    @Override
    public Optional<TagMap<class_1792>> getFilteredTagMap() {
        return Optional.ofNullable(filteredTagMap);
    }

    @Override
    public Optional<ReplacementMap> getReplacementMap() {
        return Optional.ofNullable(replacementMap);
    }

    @Override
    public Optional<UnifyConfig> getUnifyConfig() {
        return Optional.ofNullable(unifyConfig);
    }
}
