/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.recipe;

import com.almostreliable.unified.AlmostUnified;
import com.almostreliable.unified.config.DuplicationConfig;
import com.almostreliable.unified.config.UnifyConfig;
import com.almostreliable.unified.recipe.ClientRecipeTracker;
import com.almostreliable.unified.recipe.RecipeContextImpl;
import com.almostreliable.unified.recipe.RecipeLink;
import com.almostreliable.unified.recipe.RecipeUnifierBuilderImpl;
import com.almostreliable.unified.recipe.unifier.RecipeHandlerFactory;
import com.almostreliable.unified.utils.JsonCompare;
import com.almostreliable.unified.utils.JsonQuery;
import com.almostreliable.unified.utils.RecipeTypePropertiesLogger;
import com.almostreliable.unified.utils.ReplacementMap;
import com.google.common.base.Stopwatch;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_2960;

public class RecipeTransformer {
    private final RecipeHandlerFactory factory;
    private final ReplacementMap replacementMap;
    private final UnifyConfig unifyConfig;
    private final DuplicationConfig duplicationConfig;
    private final RecipeTypePropertiesLogger propertiesLogger = new RecipeTypePropertiesLogger();

    public RecipeTransformer(RecipeHandlerFactory factory, ReplacementMap replacementMap, UnifyConfig unifyConfig, DuplicationConfig duplicationConfig) {
        this.factory = factory;
        this.replacementMap = replacementMap;
        this.unifyConfig = unifyConfig;
        this.duplicationConfig = duplicationConfig;
    }

    public boolean hasValidRecipeType(JsonObject json) {
        JsonElement jsonElement = json.get("type");
        if (jsonElement instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)jsonElement;
            class_2960 type = class_2960.method_12829((String)primitive.getAsString());
            return type != null && this.unifyConfig.includeRecipeType(type);
        }
        return false;
    }

    public Result transformRecipes(Map<class_2960, JsonElement> recipes, boolean skipClientTracking) {
        Stopwatch transformationTimer = Stopwatch.createStarted();
        AlmostUnified.LOG.warn("Recipe count: " + recipes.size());
        ClientRecipeTracker.RawBuilder tracker = skipClientTracking ? null : new ClientRecipeTracker.RawBuilder();
        Result result = new Result();
        Map<class_2960, List<RecipeLink>> byType = this.groupRecipesByType(recipes);
        class_2960 fcLocation = new class_2960("forge:conditional");
        byType.forEach((type, recipeLinks) -> {
            if (type.equals((Object)fcLocation)) {
                recipeLinks.forEach(recipeLink -> this.handleForgeConditionals((RecipeLink)recipeLink).ifPresent(json -> recipes.put(recipeLink.getId(), (JsonElement)json)));
            } else {
                this.transformRecipes((List<RecipeLink>)recipeLinks, recipes, tracker);
            }
            result.addAll((Collection<RecipeLink>)recipeLinks);
        });
        AlmostUnified.LOG.warn("Recipe count afterwards: " + recipes.size() + " (done in " + transformationTimer.stop() + ")");
        this.unifyConfig.clearCache();
        this.duplicationConfig.clearCache();
        if (tracker != null) {
            recipes.putAll(tracker.compute());
        }
        return result;
    }

    private Optional<JsonObject> handleForgeConditionals(RecipeLink recipeLink) {
        JsonObject copy = recipeLink.getOriginal().deepCopy();
        JsonElement jsonElement = copy.get("recipes");
        if (jsonElement instanceof JsonArray) {
            JsonArray recipes = (JsonArray)jsonElement;
            for (JsonElement element : recipes) {
                JsonQuery.of(element, "recipe").asObject().map(jsonObject -> RecipeLink.of(recipeLink.getId(), jsonObject)).ifPresent(temporaryLink -> {
                    this.unifyRecipe((RecipeLink)temporaryLink);
                    if (temporaryLink.isUnified()) {
                        element.getAsJsonObject().add("recipe", (JsonElement)temporaryLink.getUnified());
                    }
                });
            }
            if (!copy.equals((Object)recipeLink.getOriginal())) {
                recipeLink.setUnified(copy);
                return Optional.of(copy);
            }
        }
        return Optional.empty();
    }

    private void transformRecipes(List<RecipeLink> recipeLinks, Map<class_2960, JsonElement> allRecipes, @Nullable ClientRecipeTracker.RawBuilder tracker) {
        LinkedHashSet<RecipeLink> unified = this.unifyRecipes(recipeLinks, r -> allRecipes.put(r.getId(), (JsonElement)r.getUnified()));
        Set<RecipeLink.DuplicateLink> duplicates = this.handleDuplicates(this.duplicationConfig.isStrictMode() ? recipeLinks : unified, recipeLinks);
        duplicates.stream().flatMap(d -> d.getRecipesWithoutMaster().stream()).forEach(r -> allRecipes.remove(r.getId()));
        if (tracker != null) {
            unified.forEach(tracker::add);
        }
    }

    public Map<class_2960, List<RecipeLink>> groupRecipesByType(Map<class_2960, JsonElement> recipes) {
        return recipes.entrySet().stream().filter(entry -> this.includeRecipe((class_2960)entry.getKey(), (JsonElement)entry.getValue())).map(entry -> RecipeLink.of((class_2960)entry.getKey(), ((JsonElement)entry.getValue()).getAsJsonObject())).filter(Objects::nonNull).sorted(Comparator.comparing(entry -> entry.getId().toString())).collect(Collectors.groupingByConcurrent(RecipeLink::getType));
    }

    private boolean includeRecipe(class_2960 recipe, JsonElement json) {
        return this.unifyConfig.includeRecipe(recipe) && json.isJsonObject() && this.hasValidRecipeType(json.getAsJsonObject());
    }

    private Set<RecipeLink.DuplicateLink> handleDuplicates(Collection<RecipeLink> recipeLinks, List<RecipeLink> linksToCompare) {
        HashSet<RecipeLink.DuplicateLink> duplicates = new HashSet<RecipeLink.DuplicateLink>(recipeLinks.size());
        for (RecipeLink recipeLink : recipeLinks) {
            if (!this.handleDuplicate(recipeLink, linksToCompare) || recipeLink.getDuplicateLink() == null) continue;
            duplicates.add(recipeLink.getDuplicateLink());
        }
        return duplicates;
    }

    private boolean handleDuplicate(RecipeLink curRecipe, List<RecipeLink> recipes) {
        if (this.duplicationConfig.shouldIgnoreRecipe(curRecipe)) {
            return false;
        }
        JsonCompare.CompareContext compareContext = this.duplicationConfig.getCompareContext(curRecipe);
        boolean foundDuplicate = false;
        for (RecipeLink recipeLink : recipes) {
            if (!curRecipe.getType().equals((Object)recipeLink.getType())) {
                throw new IllegalStateException("Recipe types do not match for " + curRecipe.getId() + " and " + recipeLink.getId());
            }
            if (recipeLink == curRecipe || this.duplicationConfig.shouldIgnoreRecipe(recipeLink)) continue;
            foundDuplicate |= curRecipe.handleDuplicate(recipeLink, compareContext);
        }
        return foundDuplicate;
    }

    private LinkedHashSet<RecipeLink> unifyRecipes(List<RecipeLink> recipeLinks, Consumer<RecipeLink> onUnified) {
        LinkedHashSet<RecipeLink> unified = new LinkedHashSet<RecipeLink>(recipeLinks.size());
        for (RecipeLink recipeLink : recipeLinks) {
            this.unifyRecipe(recipeLink);
            if (!recipeLink.isUnified()) continue;
            onUnified.accept(recipeLink);
            unified.add(recipeLink);
        }
        return unified;
    }

    public void unifyRecipe(RecipeLink recipe) {
        try {
            RecipeContextImpl ctx = new RecipeContextImpl(recipe.getOriginal(), this.replacementMap);
            RecipeUnifierBuilderImpl builder = new RecipeUnifierBuilderImpl();
            this.factory.fillUnifier(builder, ctx);
            JsonObject result = builder.unify(recipe.getOriginal(), ctx);
            if (result != null) {
                recipe.setUnified(result);
            }
            this.propertiesLogger.log(recipe.getType(), recipe.getOriginal(), builder.getKeys());
        }
        catch (Exception e) {
            AlmostUnified.LOG.warn("Error unifying recipe '{}': {}", (Object)recipe.getId(), (Object)e.getMessage());
            e.printStackTrace();
        }
    }

    public static class Result {
        private final Multimap<class_2960, RecipeLink> allRecipesByType = HashMultimap.create();
        private final Multimap<class_2960, RecipeLink> unifiedRecipesByType = HashMultimap.create();
        private final Multimap<class_2960, RecipeLink.DuplicateLink> duplicatesByType = HashMultimap.create();

        private void add(RecipeLink link) {
            if (this.allRecipesByType.containsEntry((Object)link.getType(), (Object)link)) {
                throw new IllegalStateException("Already tracking recipe type " + link.getType());
            }
            this.allRecipesByType.put((Object)link.getType(), (Object)link);
            if (link.isUnified()) {
                this.unifiedRecipesByType.put((Object)link.getType(), (Object)link);
            }
            if (link.hasDuplicateLink()) {
                this.duplicatesByType.put((Object)link.getType(), (Object)link.getDuplicateLink());
            }
        }

        private void addAll(Collection<RecipeLink> links) {
            links.forEach(this::add);
        }

        public Collection<RecipeLink> getRecipes(class_2960 type) {
            return Collections.unmodifiableCollection(this.allRecipesByType.get((Object)type));
        }

        public Collection<RecipeLink> getUnifiedRecipes(class_2960 type) {
            return Collections.unmodifiableCollection(this.unifiedRecipesByType.get((Object)type));
        }

        public Collection<RecipeLink.DuplicateLink> getDuplicates(class_2960 type) {
            return Collections.unmodifiableCollection(this.duplicatesByType.get((Object)type));
        }

        public int getRecipeCount() {
            return this.allRecipesByType.size();
        }

        public int getUnifiedRecipeCount() {
            return this.unifiedRecipesByType.size();
        }

        public int getDuplicatesCount() {
            return this.duplicatesByType.size();
        }

        public int getDuplicateRecipesCount() {
            return this.duplicatesByType.values().stream().mapToInt(l -> l.getRecipes().size()).sum();
        }

        public Set<class_2960> getUnifiedRecipeTypes() {
            return this.unifiedRecipesByType.keySet();
        }
    }
}

