/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.recipe;

import com.almostreliable.unified.AlmostUnified;
import com.almostreliable.unified.utils.JsonCompare;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public final class RecipeLink {
    private static final Map<String, class_2960> PARSED_TYPE_CACHE = new HashMap<String, class_2960>();
    private static final class_2960 SHAPED_RECIPE_TYPE = PARSED_TYPE_CACHE.computeIfAbsent("minecraft:crafting_shaped", class_2960::new);
    private static final class_2960 SHAPELESS_RECIPE_TYPE = PARSED_TYPE_CACHE.computeIfAbsent("minecraft:crafting_shapeless", class_2960::new);
    private final class_2960 id;
    private final class_2960 type;
    private final JsonObject originalRecipe;
    private final boolean isCraftingRecipe;
    @Nullable
    private DuplicateLink duplicateLink;
    @Nullable
    private JsonObject unifiedRecipe;
    @Nullable
    private class_1792 craftingRecipeOutput;

    private RecipeLink(class_2960 id, JsonObject originalRecipe, class_2960 type) {
        this.id = id;
        this.originalRecipe = originalRecipe;
        this.type = type;
        this.isCraftingRecipe = type == SHAPED_RECIPE_TYPE || type == SHAPELESS_RECIPE_TYPE;
    }

    @Nullable
    public static RecipeLink of(class_2960 id, JsonObject originalRecipe) {
        try {
            String typeString = originalRecipe.get("type").getAsString();
            class_2960 type = PARSED_TYPE_CACHE.computeIfAbsent(typeString, class_2960::new);
            return new RecipeLink(id, originalRecipe, type);
        }
        catch (Exception e) {
            AlmostUnified.LOG.warn("Could not detect recipe type for recipe '{}', skipping.", (Object)id);
            return null;
        }
    }

    @Nullable
    public static RecipeLink compare(RecipeLink first, RecipeLink second, JsonCompare.CompareContext compareContext) {
        if (first.isCraftingRecipe && first.getCraftingRecipeOutput() != second.getCraftingRecipeOutput()) {
            return null;
        }
        JsonObject selfActual = first.getActual();
        JsonObject toCompareActual = second.getActual();
        JsonObject compare = null;
        if (first.isCraftingRecipe) {
            compare = JsonCompare.compareShaped(selfActual, toCompareActual, compareContext);
        } else if (JsonCompare.matches(selfActual, toCompareActual, compareContext)) {
            compare = JsonCompare.compare(compareContext.settings().getRules(), selfActual, toCompareActual);
        }
        if (compare == null) {
            return null;
        }
        if (compare == selfActual) {
            return first;
        }
        if (compare == toCompareActual) {
            return second;
        }
        return null;
    }

    public class_2960 getId() {
        return this.id;
    }

    public class_2960 getType() {
        return this.type;
    }

    public JsonObject getOriginal() {
        return this.originalRecipe;
    }

    public boolean hasDuplicateLink() {
        return this.duplicateLink != null;
    }

    @Nullable
    public DuplicateLink getDuplicateLink() {
        return this.duplicateLink;
    }

    private void updateDuplicateLink(@Nullable DuplicateLink duplicateLink) {
        Objects.requireNonNull(duplicateLink);
        if (this.hasDuplicateLink() && this.getDuplicateLink() != duplicateLink) {
            throw new IllegalStateException("Recipe is already linked to " + this.getDuplicateLink());
        }
        this.duplicateLink = duplicateLink;
        this.duplicateLink.addDuplicate(this);
    }

    @Nullable
    public JsonObject getUnified() {
        return this.unifiedRecipe;
    }

    public boolean isUnified() {
        return this.unifiedRecipe != null;
    }

    void setUnified(JsonObject json) {
        Objects.requireNonNull(json);
        if (this.isUnified()) {
            throw new IllegalStateException("Recipe already unified");
        }
        this.unifiedRecipe = json;
    }

    @Nullable
    private class_1792 getCraftingRecipeOutput() {
        if (this.craftingRecipeOutput == null) {
            JsonObject recipe = this.unifiedRecipe == null ? this.originalRecipe : this.unifiedRecipe;
            try {
                String outputString = recipe.getAsJsonObject("result").getAsJsonPrimitive("item").getAsString();
                this.craftingRecipeOutput = (class_1792)class_7923.field_41178.method_10223(new class_2960(outputString));
            }
            catch (Exception e) {
                AlmostUnified.LOG.warn("Could not detect crafting recipe output for recipe '{}'.", (Object)this.id);
                this.craftingRecipeOutput = class_1802.field_8162;
            }
        }
        if (this.craftingRecipeOutput == class_1802.field_8162) {
            return null;
        }
        return this.craftingRecipeOutput;
    }

    public String toString() {
        String duplicate = this.duplicateLink != null ? " (duplicate)" : "";
        String unified = this.unifiedRecipe != null ? " (unified)" : "";
        return String.format("['%s'] %s%s%s", this.type, this.id, duplicate, unified);
    }

    public boolean handleDuplicate(RecipeLink otherRecipe, JsonCompare.CompareContext compareContext) {
        DuplicateLink selfDuplicate = this.getDuplicateLink();
        DuplicateLink otherDuplicate = otherRecipe.getDuplicateLink();
        if (selfDuplicate != null && otherDuplicate != null) {
            return selfDuplicate == otherDuplicate;
        }
        if (selfDuplicate == null && otherDuplicate == null) {
            RecipeLink compare = RecipeLink.compare(this, otherRecipe, compareContext);
            if (compare == null) {
                return false;
            }
            DuplicateLink newLink = new DuplicateLink(compare);
            this.updateDuplicateLink(newLink);
            otherRecipe.updateDuplicateLink(newLink);
            return true;
        }
        if (otherDuplicate != null) {
            RecipeLink compare = RecipeLink.compare(this, otherDuplicate.getMaster(), compareContext);
            if (compare == null) {
                return false;
            }
            otherDuplicate.updateMaster(compare);
            this.updateDuplicateLink(otherDuplicate);
            return true;
        }
        RecipeLink compare = RecipeLink.compare(selfDuplicate.getMaster(), otherRecipe, compareContext);
        if (compare == null) {
            return false;
        }
        selfDuplicate.updateMaster(compare);
        otherRecipe.updateDuplicateLink(selfDuplicate);
        return true;
    }

    public JsonObject getActual() {
        return this.getUnified() != null ? this.getUnified() : this.getOriginal();
    }

    static {
        PARSED_TYPE_CACHE.putIfAbsent("crafting_shaped", SHAPED_RECIPE_TYPE);
        PARSED_TYPE_CACHE.putIfAbsent("crafting_shapeless", SHAPELESS_RECIPE_TYPE);
    }

    public static final class DuplicateLink {
        private final Set<RecipeLink> recipes = new HashSet<RecipeLink>();
        private RecipeLink currentMaster;

        private DuplicateLink(RecipeLink master) {
            this.updateMaster(master);
        }

        private void updateMaster(RecipeLink master) {
            Objects.requireNonNull(master);
            this.addDuplicate(master);
            this.currentMaster = master;
        }

        private void addDuplicate(RecipeLink recipe) {
            this.recipes.add(recipe);
        }

        public RecipeLink getMaster() {
            return this.currentMaster;
        }

        public Set<RecipeLink> getRecipes() {
            return Collections.unmodifiableSet(this.recipes);
        }

        public Set<RecipeLink> getRecipesWithoutMaster() {
            return this.recipes.stream().filter(recipe -> recipe != this.currentMaster).collect(Collectors.toSet());
        }

        public String toString() {
            return "Link{currentMaster=" + this.currentMaster + ", recipes=" + this.recipes.size() + "}";
        }
    }
}

