/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.utils;

import com.almostreliable.unified.AlmostUnifiedCommon;
import com.almostreliable.unified.AlmostUnifiedPlatform;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;

public final class FileUtils {
    private FileUtils() {
    }

    public static void createGitIgnore() {
        Path path = AlmostUnifiedPlatform.INSTANCE.getConfigPath();
        if (!Files.exists(path.resolve(".gitignore"), new LinkOption[0])) {
            FileUtils.write(path, ".gitignore", sb -> sb.append("debug").append(".json").append("\n"));
        }
    }

    public static void writeDebugLog(String fileName, Consumer<StringBuilder> callback) {
        FileUtils.write(AlmostUnifiedPlatform.INSTANCE.getDebugLogPath(), fileName, callback);
    }

    private static void write(Path path, String fileName, Consumer<StringBuilder> callback) {
        StringBuilder sb = new StringBuilder();
        callback.accept(sb);
        try {
            Files.createDirectories(path, new FileAttribute[0]);
            Path filePath = path.resolve(fileName);
            Files.writeString(filePath, (CharSequence)sb.toString(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            AlmostUnifiedCommon.LOGGER.warn("Couldn't write to file '{}'.", (Object)fileName, (Object)e);
        }
    }
}

