/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.unification.recipe;

import com.almostreliable.unified.api.AlmostUnified;
import com.almostreliable.unified.api.constant.RecipeConstants;
import com.almostreliable.unified.api.unification.UnificationEntry;
import com.almostreliable.unified.api.unification.UnificationLookup;
import com.almostreliable.unified.api.unification.recipe.CustomIngredientUnifier;
import com.almostreliable.unified.api.unification.recipe.CustomIngredientUnifierRegistry;
import com.almostreliable.unified.api.unification.recipe.RecipeJson;
import com.almostreliable.unified.api.unification.recipe.UnificationHelper;
import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public record UnificationHelperImpl(CustomIngredientUnifierRegistry ingredientUnifierRegistry, UnificationLookup getUnificationLookup) implements UnificationHelper
{
    @Override
    @Nullable
    public CustomIngredientUnifier getCustomIngredientUnifier(class_2960 type) {
        return this.ingredientUnifierRegistry.getCustomIngredientUnifier(type);
    }

    @Override
    public boolean unifyInputs(RecipeJson recipe, String ... keys) {
        Preconditions.checkArgument((keys.length > 0 ? 1 : 0) != 0, (Object)"at least one key is required");
        boolean changed = false;
        for (String key : keys) {
            JsonElement jsonElement = recipe.getProperty(key);
            if (jsonElement == null) continue;
            changed |= this.unifyInputElement(jsonElement, new String[0]);
        }
        return changed;
    }

    @Override
    public boolean unifyInputElement(@Nullable JsonElement jsonElement, String ... keys) {
        boolean bl;
        block7: {
            block6: {
                if (jsonElement == null) break block6;
                JsonElement jsonElement2 = jsonElement;
                Objects.requireNonNull(jsonElement2);
                JsonElement jsonElement3 = jsonElement2;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JsonArray.class, JsonObject.class}, (Object)jsonElement3, n)) {
                    case 0: {
                        JsonArray jsonArray = (JsonArray)jsonElement3;
                        if (this.unifyInputArray(jsonArray, keys)) {
                            break;
                        }
                        break block6;
                    }
                    case 1: {
                        JsonObject jsonObject = (JsonObject)jsonElement3;
                        if (this.unifyInputObject(jsonObject, keys)) {
                            break;
                        }
                        break block6;
                    }
                    default: {
                        break block6;
                    }
                }
                bl = true;
                break block7;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean unifyInputArray(JsonArray jsonArray, String ... keys) {
        boolean changed = false;
        for (JsonElement jsonElement : jsonArray) {
            changed |= this.unifyInputElement(jsonElement, keys);
        }
        return changed;
    }

    @Override
    public boolean unifyInputObject(JsonObject jsonObject, String ... keys) {
        Boolean modified = this.handleCustomIngredientUnification(jsonObject);
        if (modified != null) {
            return modified;
        }
        boolean changed = false;
        for (String key : keys.length == 0 ? RecipeConstants.DEFAULT_INPUT_INNER_KEYS : keys) {
            JsonElement jsonElement = jsonObject.get(key);
            if (jsonElement == null) continue;
            changed |= this.unifyInputElement(jsonElement, new String[0]);
        }
        changed |= this.unifyInputTag(jsonObject);
        return changed |= this.unifyInputItem(jsonObject);
    }

    @Override
    public boolean unifyInputTag(JsonObject jsonObject) {
        JsonElement jsonElement = jsonObject.get("tag");
        if (!(jsonElement instanceof JsonPrimitive)) {
            return false;
        }
        JsonPrimitive jsonPrimitive = (JsonPrimitive)jsonElement;
        class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60654((String)jsonPrimitive.getAsString()));
        class_6862<class_1792> substituteTag = AlmostUnified.INSTANCE.getRuntimeOrThrow().getTagSubstitutions().getSubstituteTag((class_6862<class_1792>)tag);
        if (substituteTag == null) {
            return false;
        }
        jsonObject.addProperty("tag", substituteTag.comp_327().toString());
        return true;
    }

    @Override
    public boolean unifyInputItem(JsonObject jsonObject) {
        JsonElement jsonElement = jsonObject.get("item");
        if (!(jsonElement instanceof JsonPrimitive)) {
            return false;
        }
        JsonPrimitive jsonPrimitive = (JsonPrimitive)jsonElement;
        class_2960 item = class_2960.method_60654((String)jsonPrimitive.getAsString());
        class_6862<class_1792> tag = this.getUnificationLookup.getRelevantItemTag(item);
        if (tag != null) {
            jsonObject.remove("item");
            jsonObject.addProperty("tag", tag.comp_327().toString());
            return true;
        }
        return false;
    }

    @Override
    public boolean unifyOutputs(RecipeJson recipe, String ... keys) {
        return this.unifyOutputs(recipe, true, keys);
    }

    @Override
    public boolean unifyOutputs(RecipeJson recipe, boolean tagsToItems, String ... keys) {
        Preconditions.checkArgument((keys.length > 0 ? 1 : 0) != 0, (Object)"at least one key is required");
        boolean changed = false;
        for (String key : keys) {
            JsonElement jsonElement = recipe.getProperty(key);
            if (jsonElement == null) continue;
            if (jsonElement instanceof JsonPrimitive) {
                JsonPrimitive jsonPrimitive = (JsonPrimitive)jsonElement;
                JsonPrimitive replacement = this.handleOutputItemReplacement(jsonPrimitive);
                if (replacement == null) continue;
                recipe.setProperty(key, (JsonElement)replacement);
                changed = true;
                continue;
            }
            changed |= this.unifyOutputElement(jsonElement, tagsToItems, new String[0]);
        }
        return changed;
    }

    @Override
    public boolean unifyOutputs(RecipeJson recipe, String key, boolean tagsToItems, String ... innerKeys) {
        Preconditions.checkArgument((innerKeys.length > 0 ? 1 : 0) != 0, (Object)"at least one inner key is required");
        return this.unifyOutputElement(recipe.getProperty(key), tagsToItems, innerKeys);
    }

    @Override
    public boolean unifyOutputElement(@Nullable JsonElement json, boolean tagsToItems, String ... keys) {
        boolean bl;
        block7: {
            block6: {
                if (json == null) break block6;
                JsonElement jsonElement = json;
                Objects.requireNonNull(jsonElement);
                JsonElement jsonElement2 = jsonElement;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JsonArray.class, JsonObject.class}, (Object)jsonElement2, n)) {
                    case 0: {
                        JsonArray jsonArray = (JsonArray)jsonElement2;
                        if (this.unifyOutputArray(jsonArray, tagsToItems, keys)) {
                            break;
                        }
                        break block6;
                    }
                    case 1: {
                        JsonObject jsonObject = (JsonObject)jsonElement2;
                        if (this.unifyOutputObject(jsonObject, tagsToItems, keys)) {
                            break;
                        }
                        break block6;
                    }
                    default: {
                        break block6;
                    }
                }
                bl = true;
                break block7;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean unifyOutputArray(JsonArray jsonArray, boolean tagsToItems, String ... keys) {
        boolean changed = false;
        for (JsonElement jsonElement : jsonArray) {
            changed |= this.unifyOutputElement(jsonElement, tagsToItems, keys);
        }
        return changed;
    }

    @Override
    public boolean unifyOutputObject(JsonObject jsonObject, boolean tagsToItems, String ... keys) {
        Boolean modified = this.handleCustomIngredientUnification(jsonObject);
        if (modified != null) {
            return modified;
        }
        boolean changed = false;
        for (String key : keys.length == 0 ? RecipeConstants.DEFAULT_OUTPUT_INNER_KEYS : keys) {
            JsonElement jsonElement = jsonObject.get(key);
            if (jsonElement == null) continue;
            changed |= this.unifyOutputElement(jsonElement, tagsToItems, keys);
        }
        changed |= this.unifyOutputTag(jsonObject, tagsToItems);
        return changed |= this.unifyOutputItem(jsonObject);
    }

    @Override
    public boolean unifyOutputTag(JsonObject jsonObject, boolean tagsToItems) {
        JsonElement jsonElement = jsonObject.get("tag");
        if (!(jsonElement instanceof JsonPrimitive)) {
            return false;
        }
        JsonPrimitive jsonPrimitive = (JsonPrimitive)jsonElement;
        class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60654((String)jsonPrimitive.getAsString()));
        if (tagsToItems) {
            return this.handleTagToItemReplacement(jsonObject, (class_6862<class_1792>)tag);
        }
        class_6862<class_1792> substituteTag = AlmostUnified.INSTANCE.getRuntimeOrThrow().getTagSubstitutions().getSubstituteTag((class_6862<class_1792>)tag);
        if (substituteTag == null) {
            return false;
        }
        jsonObject.addProperty("tag", substituteTag.comp_327().toString());
        return true;
    }

    @Override
    public boolean handleTagToItemReplacement(JsonObject jsonObject, class_6862<class_1792> tag) {
        return this.handleTagToItemReplacement(jsonObject, "item", tag);
    }

    @Override
    public boolean handleTagToItemReplacement(JsonObject jsonObject, String key, class_6862<class_1792> tag) {
        UnificationEntry<class_1792> entry = this.getUnificationLookup.getTagTargetItem(tag);
        if (entry == null) {
            return false;
        }
        jsonObject.remove("tag");
        jsonObject.addProperty(key, entry.id().toString());
        return true;
    }

    @Override
    public boolean unifyOutputItem(JsonObject jsonObject) {
        boolean changed = this.unifyOutputItem(jsonObject, "item");
        return changed |= this.unifyOutputItem(jsonObject, "id");
    }

    @Override
    public boolean unifyOutputItem(JsonObject jsonObject, String key) {
        JsonElement jsonElement = jsonObject.get(key);
        if (!(jsonElement instanceof JsonPrimitive)) {
            return false;
        }
        JsonPrimitive jsonPrimitive = (JsonPrimitive)jsonElement;
        JsonPrimitive replacement = this.handleOutputItemReplacement(jsonPrimitive);
        if (replacement == null) {
            return false;
        }
        jsonObject.addProperty(key, replacement.getAsString());
        return true;
    }

    @Override
    @Nullable
    public JsonPrimitive handleOutputItemReplacement(JsonPrimitive jsonPrimitive) {
        class_2960 item = class_2960.method_60654((String)jsonPrimitive.getAsString());
        UnificationEntry<class_1792> entry = this.getUnificationLookup.getVariantItemTarget(item);
        if (entry == null || entry.id().equals((Object)item)) {
            return null;
        }
        return new JsonPrimitive(entry.id().toString());
    }

    @Nullable
    private Boolean handleCustomIngredientUnification(JsonObject jsonObject) {
        JsonElement jsonElement = jsonObject.get("type");
        if (!(jsonElement instanceof JsonPrimitive)) {
            return null;
        }
        JsonPrimitive jsonPrimitive = (JsonPrimitive)jsonElement;
        class_2960 type = class_2960.method_12829((String)jsonPrimitive.getAsString());
        if (type == null) {
            return null;
        }
        CustomIngredientUnifier unifier = this.getCustomIngredientUnifier(type);
        if (unifier == null) {
            return null;
        }
        jsonObject.remove("type");
        boolean changed = unifier.unify(this, jsonObject);
        jsonObject.addProperty("type", type.toString());
        return changed;
    }
}

