/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.unification;

import com.almostreliable.unified.AlmostUnifiedCommon;
import com.almostreliable.unified.api.unification.ModPriorities;
import com.almostreliable.unified.api.unification.UnificationEntry;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;

public final class ModPrioritiesImpl
implements ModPriorities {
    private final List<String> modPriorities;
    private final Map<class_6862<class_1792>, String> priorityOverrides;

    public ModPrioritiesImpl(List<String> modPriorities, Map<class_6862<class_1792>, String> priorityOverrides) {
        this.modPriorities = modPriorities;
        this.priorityOverrides = priorityOverrides;
    }

    @Override
    @Nullable
    public String getPriorityOverride(class_6862<class_1792> tag) {
        return this.priorityOverrides.get(tag);
    }

    @Override
    @Nullable
    public UnificationEntry<class_1792> findPriorityOverrideItem(class_6862<class_1792> tag, List<UnificationEntry<class_1792>> items) {
        String priorityOverride = this.getPriorityOverride(tag);
        if (priorityOverride == null) {
            return null;
        }
        UnificationEntry<class_1792> entry = ModPrioritiesImpl.findItemByNamespace(items, priorityOverride);
        if (entry != null) {
            return entry;
        }
        AlmostUnifiedCommon.LOGGER.warn("Priority override mod '{}' for tag '{}' does not contain a valid item. Falling back to default priority.", (Object)priorityOverride, (Object)tag.comp_327());
        return null;
    }

    @Override
    @Nullable
    public UnificationEntry<class_1792> findTargetItem(class_6862<class_1792> tag, List<UnificationEntry<class_1792>> items) {
        UnificationEntry<class_1792> overrideEntry = this.findPriorityOverrideItem(tag, items);
        if (overrideEntry != null) {
            return overrideEntry;
        }
        for (String modPriority : this.modPriorities) {
            UnificationEntry<class_1792> entry = ModPrioritiesImpl.findItemByNamespace(items, modPriority);
            if (entry == null) continue;
            return entry;
        }
        return null;
    }

    @Override
    public Iterator<String> iterator() {
        return this.modPriorities.iterator();
    }

    @Nullable
    private static UnificationEntry<class_1792> findItemByNamespace(List<UnificationEntry<class_1792>> items, String namespace) {
        for (UnificationEntry<class_1792> item : items) {
            if (!item.id().method_12836().equals(namespace)) continue;
            return item;
        }
        return null;
    }
}

