/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.compat.viewer;

import com.almostreliable.unified.unification.recipe.RecipeLink;
import com.almostreliable.unified.utils.Utils;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;

public record ClientRecipeTracker(String namespace, Map<class_2960, ClientRecipeLink> recipes) implements class_1860<class_9695>
{
    public static final class_2960 ID = Utils.getRL("client_recipe_tracker");
    public static final String RECIPES = "recipes";
    public static final String NAMESPACE = "namespace";
    public static final int UNIFIED_FLAG = 1;
    public static final int DUPLICATE_FLAG = 2;
    public static final class_1865<ClientRecipeTracker> SERIALIZER = new Serializer();
    public static final class_3956<ClientRecipeTracker> TYPE = new class_3956<ClientRecipeTracker>(){

        public String toString() {
            return ID.method_12832();
        }
    };

    private static String createRaw(boolean isUnified, boolean isDuplicate, String idPath) {
        int flag = 0;
        if (isUnified) {
            flag |= 1;
        }
        if (isDuplicate) {
            flag |= 2;
        }
        return flag + "$" + idPath;
    }

    public boolean method_8115(class_9695 recipeInput, class_1937 level) {
        return false;
    }

    public class_1799 method_8116(class_9695 recipeInput, class_7225.class_7874 provider) {
        return class_1799.field_8037;
    }

    public boolean method_8113(int width, int height) {
        return false;
    }

    public class_1799 method_8110(class_7225.class_7874 provider) {
        return class_1799.field_8037;
    }

    public class_1865<?> method_8119() {
        return SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return TYPE;
    }

    private void add(ClientRecipeLink clientRecipeLink) {
        this.recipes.put(clientRecipeLink.id(), clientRecipeLink);
    }

    @Nullable
    public ClientRecipeLink getLink(class_2960 recipeId) {
        return this.recipes.get(recipeId);
    }

    public List<String> getLinkStrings() {
        return this.recipes.values().stream().map(l -> ClientRecipeTracker.createRaw(l.isUnified, l.isDuplicate, l.id.method_12832())).toList();
    }

    public record ClientRecipeLink(class_2960 id, boolean isUnified, boolean isDuplicate) {
    }

    public static class Serializer
    implements class_1865<ClientRecipeTracker> {
        public static final MapCodec<ClientRecipeTracker> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf(ClientRecipeTracker.NAMESPACE).forGetter(ClientRecipeTracker::namespace), (App)Codec.list((Codec)Codec.STRING).fieldOf(ClientRecipeTracker.RECIPES).forGetter(ClientRecipeTracker::getLinkStrings)).apply((Applicative)instance, Serializer::of));
        public static final class_9139<class_9129, ClientRecipeTracker> STREAM_CODEC = new class_9139<class_9129, ClientRecipeTracker>(){

            public ClientRecipeTracker decode(class_9129 buffer) {
                int size = buffer.readInt();
                String namespace = buffer.method_19772();
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (int i = 0; i < size; ++i) {
                    String raw = buffer.method_19772();
                    ClientRecipeLink clientRecipeLink = Serializer.parseRaw(namespace, raw);
                    builder.put((Object)clientRecipeLink.id(), (Object)clientRecipeLink);
                }
                return new ClientRecipeTracker(namespace, (Map<class_2960, ClientRecipeLink>)builder.build());
            }

            public void encode(class_9129 buffer, ClientRecipeTracker recipe) {
                buffer.method_53002(recipe.recipes.size());
                buffer.method_10814(recipe.namespace);
                for (ClientRecipeLink clientRecipeLink : recipe.recipes.values()) {
                    String raw = ClientRecipeTracker.createRaw(clientRecipeLink.isUnified(), clientRecipeLink.isDuplicate(), clientRecipeLink.id().method_12832());
                    buffer.method_10814(raw);
                }
            }
        };

        public MapCodec<ClientRecipeTracker> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, ClientRecipeTracker> method_56104() {
            return STREAM_CODEC;
        }

        private static ClientRecipeTracker of(String namespace, List<String> recipes) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (String recipe : recipes) {
                ClientRecipeLink link = Serializer.parseRaw(namespace, recipe);
                builder.put((Object)link.id(), (Object)link);
            }
            return new ClientRecipeTracker(namespace, (Map<class_2960, ClientRecipeLink>)builder.build());
        }

        public static ClientRecipeLink parseRaw(String namespace, String raw) {
            String[] split = raw.split("\\$", 2);
            int flag = Integer.parseInt(split[0]);
            boolean isUnified = (flag & 1) != 0;
            boolean isDuplicate = (flag & 2) != 0;
            return new ClientRecipeLink(class_2960.method_60655((String)namespace, (String)split[1]), isUnified, isDuplicate);
        }
    }

    public static class RawBuilder {
        private final Map<String, JsonArray> recipesByNamespace = new HashMap<String, JsonArray>();

        public void add(RecipeLink recipe) {
            class_2960 recipeId = recipe.getId();
            JsonArray array = this.recipesByNamespace.computeIfAbsent(recipeId.method_12836(), k -> new JsonArray());
            array.add(ClientRecipeTracker.createRaw(recipe.isUnified(), recipe.hasDuplicateLink(), recipeId.method_12832()));
        }

        public Map<class_2960, JsonObject> compute() {
            HashMap<class_2960, JsonObject> result = new HashMap<class_2960, JsonObject>();
            this.recipesByNamespace.forEach((namespace, recipes) -> {
                JsonObject json = new JsonObject();
                json.addProperty("type", ID.toString());
                json.addProperty(ClientRecipeTracker.NAMESPACE, namespace);
                json.add(ClientRecipeTracker.RECIPES, (JsonElement)recipes);
                result.put(Utils.getRL(namespace), json);
            });
            return result;
        }
    }
}

