package com.almostreliable.unified.compat.viewer;

import com.almostreliable.unified.AlmostUnifiedCommon;
import com.almostreliable.unified.api.unification.UnificationEntry;
import com.almostreliable.unified.api.unification.UnificationLookup;
import com.almostreliable.unified.api.unification.UnificationSettings;
import com.almostreliable.unified.utils.Utils;
import com.almostreliable.unified.utils.VanillaTagWrapper;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public final class ItemHider {

    public static final class_6862<class_1792> HIDE_TAG = class_6862.method_40092(class_7924.field_41197, Utils.getRL("hide"));
    public static final class_6862<class_1792> EMI_STRICT_TAG = class_6862.method_40092(class_7924.field_41197, Utils.getRL("emi_strict"));

    private ItemHider() {}

    public static void applyHideTags(VanillaTagWrapper<class_1792> tags, Collection<UnificationSettings> handlers, boolean emiHidingStrict) {
        for (var handler : handlers) {
            if (handler.shouldHideVariantItems()) {
                applyHideTags(tags, handler);
            }
        }

        if (emiHidingStrict) {
            tags.add(EMI_STRICT_TAG.comp_327(), class_7923.field_41178.method_47983(class_1802.field_8688));
        }
    }

    public static void applyHideTags(VanillaTagWrapper<class_1792> tags, UnificationSettings handler) {
        var holdersToHide = createHidingItems(handler);
        for (class_6880<class_1792> holder : holdersToHide) {
            tags.add(HIDE_TAG.comp_327(), holder);
        }
    }

    public static Set<class_6880<class_1792>> createHidingItems(UnificationSettings handler) {
        Set<class_6880<class_1792>> hidings = new HashSet<>();

        for (class_6862<class_1792> tag : handler.getTags()) {
            var entriesByTag = handler.getTagEntries(tag);

            // avoid handling single entries and tags that only contain the same namespace for all items
            if (Utils.allSameNamespace(entriesByTag)) continue;

            Set<UnificationEntry<class_1792>> replacements = new HashSet<>();
            for (var holder : entriesByTag) {
                replacements.add(getReplacementForItem(handler, holder));
            }

            Set<class_6880<class_1792>> toHide = new HashSet<>();
            Set<String> toHideIds = new HashSet<>();
            for (var entry : entriesByTag) {
                if (!replacements.contains(entry)) {
                    toHide.add(entry.asHolderOrThrow());
                    toHideIds.add(entry.id().toString());
                }
            }

            if (toHide.isEmpty()) continue;

            AlmostUnifiedCommon.LOGGER.info(
                "[AutoHiding] Hiding {}/{} items for tag '#{}' -> {}",
                toHide.size(),
                entriesByTag.size(),
                tag.comp_327(),
                toHideIds
            );

            hidings.addAll(toHide);
        }

        return hidings;
    }

    /**
     * Returns the replacement for the given item, or the item itself if no replacement is found.
     * <p>
     * Returning the item itself is important for stone variant detection.
     *
     * @param repMap The replacement map.
     * @param entry  The holder to get the replacement for.
     * @return The replacement for the given item, or the item itself if no replacement is found.
     */
    private static UnificationEntry<class_1792> getReplacementForItem(UnificationLookup repMap, UnificationEntry<class_1792> entry) {
        var replacement = repMap.getVariantItemTarget(entry);
        if (replacement == null) return entry;
        return replacement;
    }
}
