/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.unification.recipe;

import com.almostreliable.unified.AlmostUnifiedCommon;
import com.almostreliable.unified.api.unification.recipe.RecipeData;
import com.almostreliable.unified.utils.JsonCompare;
import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public final class RecipeLink
implements RecipeData,
Comparable<RecipeLink> {
    private static final Map<String, class_2960> PARSED_TYPE_CACHE = new HashMap<String, class_2960>();
    private static final class_2960 SHAPED_RECIPE_TYPE = PARSED_TYPE_CACHE.computeIfAbsent("minecraft:crafting_shaped", class_2960::method_60654);
    private static final class_2960 SHAPELESS_RECIPE_TYPE = PARSED_TYPE_CACHE.computeIfAbsent("minecraft:crafting_shapeless", class_2960::method_60654);
    private final class_2960 id;
    private final class_2960 type;
    private final JsonObject originalRecipe;
    private final boolean isCraftingRecipe;
    @Nullable
    private DuplicateLink duplicateLink;
    @Nullable
    private JsonObject unifiedRecipe;
    @Nullable
    private class_1792 craftingRecipeOutput;

    private RecipeLink(class_2960 id, JsonObject originalRecipe, class_2960 type) {
        this.id = id;
        this.originalRecipe = originalRecipe;
        this.type = type;
        this.isCraftingRecipe = type == SHAPED_RECIPE_TYPE || type == SHAPELESS_RECIPE_TYPE;
    }

    @Nullable
    public static RecipeLink of(class_2960 id, JsonObject originalRecipe) {
        try {
            String typeString = originalRecipe.get("type").getAsString();
            class_2960 type = PARSED_TYPE_CACHE.computeIfAbsent(typeString, class_2960::method_60654);
            return new RecipeLink(id, originalRecipe, type);
        }
        catch (Exception e) {
            AlmostUnifiedCommon.LOGGER.warn("Could not detect recipe type for recipe '{}', skipping.", (Object)id);
            return null;
        }
    }

    public static RecipeLink ofOrThrow(class_2960 id, JsonObject originalRecipe) {
        try {
            String typeString = originalRecipe.get("type").getAsString();
            class_2960 type = PARSED_TYPE_CACHE.computeIfAbsent(typeString, class_2960::method_60654);
            return new RecipeLink(id, originalRecipe, type);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not detect recipe type for recipe " + String.valueOf(id));
        }
    }

    @Nullable
    public static RecipeLink compare(RecipeLink first, RecipeLink second, JsonCompare.CompareContext compareContext) {
        if (first.isCraftingRecipe && first.getCraftingRecipeOutput() != second.getCraftingRecipeOutput()) {
            return null;
        }
        JsonObject selfActual = first.getActual();
        JsonObject toCompareActual = second.getActual();
        JsonObject compare = null;
        if (first.isCraftingRecipe) {
            compare = JsonCompare.compareShaped(selfActual, toCompareActual, compareContext);
        } else if (JsonCompare.matches(selfActual, toCompareActual, compareContext)) {
            compare = JsonCompare.compare(compareContext.settings().getRules(), selfActual, toCompareActual);
        }
        if (compare == null) {
            return null;
        }
        if (compare == selfActual) {
            return first;
        }
        if (compare == toCompareActual) {
            return second;
        }
        return null;
    }

    @Override
    public class_2960 getId() {
        return this.id;
    }

    @Override
    public class_2960 getType() {
        return this.type;
    }

    @Override
    public boolean hasProperty(String key) {
        return this.getOriginal().has(key);
    }

    public JsonObject getOriginal() {
        return this.originalRecipe;
    }

    public boolean hasDuplicateLink() {
        return this.duplicateLink != null;
    }

    @Nullable
    public DuplicateLink getDuplicateLink() {
        return this.duplicateLink;
    }

    private void updateDuplicateLink(@Nullable DuplicateLink duplicateLink) {
        Preconditions.checkNotNull((Object)duplicateLink);
        if (this.hasDuplicateLink() && this.getDuplicateLink() != duplicateLink) {
            throw new IllegalStateException("recipe is already linked to " + String.valueOf(this.getDuplicateLink()));
        }
        this.duplicateLink = duplicateLink;
        this.duplicateLink.addDuplicate(this);
    }

    @Nullable
    public JsonObject getUnified() {
        return this.unifiedRecipe;
    }

    public boolean isUnified() {
        return this.unifiedRecipe != null;
    }

    void setUnified(JsonObject json) {
        Preconditions.checkNotNull((Object)json);
        if (this.isUnified()) {
            throw new IllegalStateException("recipe already unified");
        }
        this.unifiedRecipe = json;
    }

    @Nullable
    public class_1792 getCraftingRecipeOutput() {
        if (this.craftingRecipeOutput == null) {
            JsonObject recipe = this.unifiedRecipe == null ? this.originalRecipe : this.unifiedRecipe;
            try {
                String outputString = recipe.getAsJsonObject("result").getAsJsonPrimitive("id").getAsString();
                this.craftingRecipeOutput = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)outputString));
            }
            catch (Exception e) {
                AlmostUnifiedCommon.LOGGER.warn("Could not detect crafting recipe output for recipe '{}'.", (Object)this.id);
                this.craftingRecipeOutput = class_1802.field_8162;
            }
        }
        if (this.craftingRecipeOutput == class_1802.field_8162) {
            return null;
        }
        return this.craftingRecipeOutput;
    }

    public String toString() {
        String duplicate = this.duplicateLink != null ? " (duplicate)" : "";
        String unified = this.unifiedRecipe != null ? " (unified)" : "";
        return String.format("['%s'] %s%s%s", this.type, this.id, duplicate, unified);
    }

    public boolean handleDuplicate(RecipeLink otherRecipe, JsonCompare.CompareContext compareContext) {
        DuplicateLink selfDuplicate = this.getDuplicateLink();
        DuplicateLink otherDuplicate = otherRecipe.getDuplicateLink();
        if (selfDuplicate != null && otherDuplicate != null) {
            return selfDuplicate == otherDuplicate;
        }
        if (selfDuplicate == null && otherDuplicate == null) {
            RecipeLink compare = RecipeLink.compare(this, otherRecipe, compareContext);
            if (compare == null) {
                return false;
            }
            DuplicateLink newLink = new DuplicateLink(compare);
            this.updateDuplicateLink(newLink);
            otherRecipe.updateDuplicateLink(newLink);
            return true;
        }
        if (otherDuplicate != null) {
            RecipeLink compare = RecipeLink.compare(this, otherDuplicate.getMaster(), compareContext);
            if (compare == null) {
                return false;
            }
            otherDuplicate.updateMaster(compare);
            this.updateDuplicateLink(otherDuplicate);
            return true;
        }
        RecipeLink compare = RecipeLink.compare(selfDuplicate.getMaster(), otherRecipe, compareContext);
        if (compare == null) {
            return false;
        }
        selfDuplicate.updateMaster(compare);
        otherRecipe.updateDuplicateLink(selfDuplicate);
        return true;
    }

    public JsonObject getActual() {
        return this.getUnified() != null ? this.getUnified() : this.getOriginal();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof RecipeLink)) return false;
        RecipeLink recipeLink = (RecipeLink)o;
        if (!this.id.equals((Object)recipeLink.id)) return false;
        return true;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    @Override
    public int compareTo(@Nullable RecipeLink o) {
        if (o == null) {
            throw new NullPointerException("recipe link cannot be null");
        }
        return this.id.method_12833(o.id);
    }

    static {
        PARSED_TYPE_CACHE.putIfAbsent("crafting_shaped", SHAPED_RECIPE_TYPE);
        PARSED_TYPE_CACHE.putIfAbsent("crafting_shapeless", SHAPELESS_RECIPE_TYPE);
    }

    public static final class DuplicateLink {
        private final Set<RecipeLink> recipes = new HashSet<RecipeLink>();
        private RecipeLink currentMaster;

        private DuplicateLink(RecipeLink master) {
            this.updateMaster(master);
        }

        private void updateMaster(RecipeLink master) {
            Preconditions.checkNotNull((Object)master);
            this.addDuplicate(master);
            this.currentMaster = master;
        }

        private void addDuplicate(RecipeLink recipe) {
            this.recipes.add(recipe);
        }

        public RecipeLink getMaster() {
            return this.currentMaster;
        }

        public Set<RecipeLink> getRecipes() {
            return Collections.unmodifiableSet(this.recipes);
        }

        public Set<RecipeLink> getRecipesWithoutMaster() {
            return this.recipes.stream().filter(recipe -> recipe != this.currentMaster).collect(Collectors.toSet());
        }

        public String toString() {
            return "Link{currentMaster=" + String.valueOf(this.currentMaster) + ", recipes=" + this.recipes.size() + "}";
        }
    }
}

