package com.almostreliable.unified.unification.loot;

import com.almostreliable.unified.AlmostUnifiedCommon;
import com.almostreliable.unified.api.AlmostUnifiedRuntime;
import com.almostreliable.unified.api.unification.UnificationSettings;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import net.minecraft.class_52;
import net.minecraft.class_7225;
import net.minecraft.class_7225.class_7226;
import net.minecraft.class_7924;

public final class LootUnification {

    private LootUnification() {}

    public static void unifyLoot(AlmostUnifiedRuntime runtime, class_7225.class_7874 registries) {
        try {
            var handlers = runtime.getUnificationSettings();

            boolean enableLootUnification = handlers
                .stream()
                .anyMatch(UnificationSettings::shouldUnifyLoot);
            if (!enableLootUnification) {
                return;
            }

            var lootTableRegistry = registries.method_46762(class_7924.field_50079);

            lootTableRegistry
                .method_42017()
                .forEach(holder -> unifyLoot(holder.comp_349(), holder.method_40237().method_29177(), handlers));
        } catch (Exception e) {
            AlmostUnifiedCommon.LOGGER.error("Failed to unify loot", e);
        }
    }

    public static void unifyLoot(class_52 lootTable, class_2960 tableId, Collection<? extends UnificationSettings> unificationSettings) {
        LootUnificationHandler lootUnificationHandler = LootUnificationHandler.cast(lootTable);

        Set<UnificationSettings> modifiedTable = new HashSet<>();
        for (UnificationSettings handler : unificationSettings) {
            if (handler.shouldUnifyLoot() && handler.shouldIncludeLootTable(tableId)) {
                if (lootUnificationHandler.almostunified$unify(handler)) {
                    modifiedTable.add(handler);
                }
            }
        }

        if (!modifiedTable.isEmpty()) {
            AlmostUnifiedCommon.LOGGER.info("Loot table '{}' was unified by: {}",
                tableId,
                modifiedTable.stream().map(UnificationSettings::getName).collect(
                    Collectors.joining(", ")));
        }
    }
}
