package com.almostreliable.unified.mixin.loot;

import com.almostreliable.unified.api.unification.UnificationLookup;
import com.almostreliable.unified.unification.loot.LootUnificationHandler;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

import java.util.List;
import net.minecraft.class_69;
import net.minecraft.class_79;

@Mixin(class_69.class)
public class CompositeEntryBaseMixin implements LootUnificationHandler {
    @Shadow @Final protected List<class_79> children;

    @Override
    public boolean almostunified$unify(UnificationLookup lookup) {
        boolean unified = false;

        for (class_79 child : children) {
            if (child instanceof LootUnificationHandler handler) {
                unified |= handler.almostunified$unify(lookup);
            }
        }

        return unified;
    }
}
