package com.almostreliable.unified.mixin.runtime;

import com.almostreliable.unified.AlmostUnifiedCommon;

import com.google.gson.JsonElement;
import com.llamalad7.mixinextras.sugar.Local;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Map;
import net.minecraft.class_1863;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_7225;

// inject after most mods but before KubeJS
@Mixin(value = class_1863.class, priority = 1_099)
public class RecipeManagerMixin {

    @Shadow @Final private class_7225.class_7874 registries;

    @Inject(method = "apply(Ljava/util/Map;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V", at = @At("HEAD"))
    private void almostunified$onRecipeReload(Map<class_2960, JsonElement> recipes, class_3300 resourceManager, class_3695 profiler, CallbackInfo ci) {
        try {
            AlmostUnifiedCommon.onRecipeManagerReload(recipes, registries);
        } catch (Exception e) {
            AlmostUnifiedCommon.LOGGER.error(e.getMessage(), e);
        }
    }

    @Inject(method = "apply(Ljava/util/Map;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V", at = @At(value = "INVOKE", target = "Lorg/slf4j/Logger;error(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V"), remap = false)
    private void almostunified$onRecipeError(Map<class_2960, JsonElement> recipes, class_3300 resourceManager, class_3695 profiler, CallbackInfo ci, @Local class_2960 recipe) {
        AlmostUnifiedCommon.onRecipeManagerError(recipe);
    }

    @Inject(method = "apply(Ljava/util/Map;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V", at = @At("TAIL"))
    private void almostunified$onRecipeReloadEnd(Map<class_2960, JsonElement> recipes, class_3300 resourceManager, class_3695 profiler, CallbackInfo ci) {
        AlmostUnifiedCommon.onRecipeManagerEnd();
    }
}
