/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.unification;

import com.almostreliable.unified.AlmostUnifiedCommon;
import com.almostreliable.unified.api.unification.UnificationEntry;
import com.almostreliable.unified.api.unification.UnificationLookup;
import com.almostreliable.unified.utils.Utils;
import com.almostreliable.unified.utils.VanillaTagWrapper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class TagInheritance {
    private final Options<class_1792> itemOptions;
    private final Options<class_2248> blockOptions;

    public TagInheritance(Mode itemMode, Map<class_6862<class_1792>, Set<Pattern>> itemInheritance, Mode blockMode, Map<class_6862<class_2248>, Set<Pattern>> blockInheritance) {
        this.itemOptions = new Options(itemMode, itemInheritance);
        this.blockOptions = new Options(blockMode, blockInheritance);
    }

    public boolean apply(VanillaTagWrapper<class_1792> itemTags, VanillaTagWrapper<class_2248> blockTags, List<? extends UnificationLookup> unificationLookups) {
        HashMultimap changedItemTags = HashMultimap.create();
        HashMultimap changedBlockTags = HashMultimap.create();
        Set<TagRelation> relations = this.resolveRelations(unificationLookups);
        if (relations.isEmpty()) {
            return false;
        }
        for (TagRelation relation : relations) {
            UnificationEntry<class_1792> targetItem = relation.targetItem;
            class_6880.class_6883<class_1792> targetItemHolder = targetItem.asHolderOrThrow();
            class_6880<class_2248> targetBlockHolder = this.findTargetBlockHolder(blockTags, targetItem);
            ImmutableSet targetItemTags = (ImmutableSet)itemTags.getTags(targetItem).stream().map(rl -> class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)rl)).collect(ImmutableSet.toImmutableSet());
            for (UnificationEntry<class_1792> item : relation.items) {
                Set<class_2960> appliedItemTags = this.applyItemTags(itemTags, (class_6880<class_1792>)targetItemHolder, (Set<class_6862<class_1792>>)targetItemTags, item);
                changedItemTags.putAll(targetItem, appliedItemTags);
                if (targetBlockHolder == null) continue;
                Set<class_2960> appliedBlockTags = this.applyBlockTags(blockTags, targetBlockHolder, (Set<class_6862<class_1792>>)targetItemTags, item);
                changedBlockTags.putAll(targetItem, appliedBlockTags);
            }
        }
        if (!changedBlockTags.isEmpty()) {
            changedBlockTags.asMap().forEach((target, tags) -> AlmostUnifiedCommon.LOGGER.info("[TagInheritance] Added '{}' to block tags {}", (Object)target.id(), tags));
        }
        if (!changedItemTags.isEmpty()) {
            changedItemTags.asMap().forEach((target, tags) -> AlmostUnifiedCommon.LOGGER.info("[TagInheritance] Added '{}' to item tags {}", (Object)target.id(), tags));
            return true;
        }
        return false;
    }

    @Nullable
    private class_6880<class_2248> findTargetBlockHolder(VanillaTagWrapper<class_2248> tagMap, UnificationEntry<class_1792> targetItem) {
        Set<class_2960> blockTags = tagMap.getTags(targetItem.id());
        if (blockTags.isEmpty()) {
            return null;
        }
        return class_7923.field_41175.method_40290(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)targetItem.id()));
    }

    private Set<class_2960> applyItemTags(VanillaTagWrapper<class_1792> vanillaTags, class_6880<class_1792> targetItem, Set<class_6862<class_1792>> targetItemTags, UnificationEntry<class_1792> item) {
        Set<class_2960> itemTags = vanillaTags.getTags(item);
        HashSet<class_2960> changed = new HashSet<class_2960>();
        for (class_2960 itemTag : itemTags) {
            class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)itemTag);
            if (!this.itemOptions.shouldInherit((class_6862<class_1792>)tag, targetItemTags) || !TagInheritance.addToVanilla(targetItem, tag, vanillaTags)) continue;
            changed.add(itemTag);
        }
        return changed;
    }

    private Set<class_2960> applyBlockTags(VanillaTagWrapper<class_2248> blockTagMap, class_6880<class_2248> targetBlock, Set<class_6862<class_1792>> targetItemTags, UnificationEntry<class_1792> item) {
        Set<class_2960> blockTags = blockTagMap.getTags(item.id());
        HashSet<class_2960> changed = new HashSet<class_2960>();
        for (class_2960 blockTag : blockTags) {
            class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)blockTag);
            if (!this.blockOptions.shouldInherit((class_6862<class_2248>)tag, targetItemTags) || !TagInheritance.addToVanilla(targetBlock, tag, blockTagMap)) continue;
            changed.add(blockTag);
        }
        return changed;
    }

    private static <T> boolean addToVanilla(class_6880<T> holder, class_6862<T> tag, VanillaTagWrapper<T> vanillaTags) {
        Collection<class_6880<T>> tagHolders = vanillaTags.get(tag);
        if (tagHolders.contains(holder)) {
            return false;
        }
        vanillaTags.add(tag.comp_327(), holder);
        return true;
    }

    private Set<TagRelation> resolveRelations(Collection<? extends UnificationLookup> unificationLookups) {
        HashSet<TagRelation> relations = new HashSet<TagRelation>();
        for (UnificationLookup unificationLookup : unificationLookups) {
            for (class_6862<class_1792> unifyTag : unificationLookup.getTags()) {
                Set<UnificationEntry<class_1792>> items;
                UnificationEntry<class_1792> target;
                Collection<UnificationEntry<class_1792>> itemsByTag;
                if (this.itemOptions.skipForInheritance(unifyTag) && this.blockOptions.skipForInheritance(unifyTag) || Utils.allSameNamespace(itemsByTag = unificationLookup.getTagEntries(unifyTag)) || (target = unificationLookup.getTagTargetItem(unifyTag)) == null || (items = this.removeTargetItem(itemsByTag, target)).isEmpty()) continue;
                relations.add(new TagRelation(unifyTag, target, items));
            }
        }
        return relations;
    }

    private Set<UnificationEntry<class_1792>> removeTargetItem(Collection<UnificationEntry<class_1792>> holders, UnificationEntry<class_1792> target) {
        HashSet<UnificationEntry<class_1792>> result = new HashSet<UnificationEntry<class_1792>>(holders.size());
        for (UnificationEntry<class_1792> holder : holders) {
            if (holder.equals(target)) continue;
            result.add(holder);
        }
        return result;
    }

    private record Options<T>(Mode mode, Map<class_6862<T>, Set<Pattern>> inheritance) {
        public boolean skipForInheritance(class_6862<class_1792> tag) {
            String tagStr = tag.comp_327().toString();
            boolean modeResult = this.mode == Mode.ALLOW;
            for (Set<Pattern> patterns : this.inheritance.values()) {
                for (Pattern pattern : patterns) {
                    if (!pattern.matcher(tagStr).matches()) continue;
                    return !modeResult;
                }
            }
            return modeResult;
        }

        public boolean shouldInherit(class_6862<T> inheritanceTag, Collection<class_6862<class_1792>> targetItemTags) {
            Set<Pattern> patterns = this.inheritance.getOrDefault(inheritanceTag, Set.of());
            boolean result = this.checkPatterns(targetItemTags, patterns);
            return this.mode == Mode.ALLOW ? result : !result;
        }

        private boolean checkPatterns(Collection<class_6862<class_1792>> tags, Collection<Pattern> patterns) {
            for (Pattern pattern : patterns) {
                for (class_6862<class_1792> tag : tags) {
                    if (!pattern.matcher(tag.comp_327().toString()).matches()) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static enum Mode {
        ALLOW,
        DENY;

    }

    private record TagRelation(class_6862<class_1792> tag, UnificationEntry<class_1792> targetItem, Set<UnificationEntry<class_1792>> items) {
    }
}

