/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified;

import com.almostreliable.unified.AlmostUnifiedRuntime;
import com.almostreliable.unified.config.DebugConfig;
import com.almostreliable.unified.config.DuplicationConfig;
import com.almostreliable.unified.config.ServerConfigs;
import com.almostreliable.unified.config.UnifyConfig;
import com.almostreliable.unified.recipe.RecipeDumper;
import com.almostreliable.unified.recipe.RecipeTransformer;
import com.almostreliable.unified.recipe.unifier.RecipeHandlerFactory;
import com.almostreliable.unified.utils.ReplacementMap;
import com.almostreliable.unified.utils.TagMap;
import com.almostreliable.unified.utils.UncoveredRecipesDumper;
import com.google.gson.JsonElement;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_2960;

public final class AlmostUnifiedRuntimeImpl
implements AlmostUnifiedRuntime {
    private final UnifyConfig unifyConfig;
    private final DuplicationConfig duplicationConfig;
    private final DebugConfig debugConfig;
    private final TagMap<class_1792> tagMap;
    private final ReplacementMap replacementMap;
    private final RecipeHandlerFactory recipeHandlerFactory;

    AlmostUnifiedRuntimeImpl(ServerConfigs configs, TagMap<class_1792> tagMap, ReplacementMap repMap, RecipeHandlerFactory recipeHandlerFactory) {
        this.unifyConfig = configs.getUnifyConfig();
        this.duplicationConfig = configs.getDupConfig();
        this.debugConfig = configs.getDebugConfig();
        this.tagMap = tagMap;
        this.replacementMap = repMap;
        this.recipeHandlerFactory = recipeHandlerFactory;
    }

    @Override
    public void run(Map<class_2960, JsonElement> recipes, boolean skipClientTracking) {
        this.debugConfig.logRecipes(recipes, "recipes_before_unification.txt");
        this.debugConfig.logUnifyTagDump(this.tagMap);
        long startTime = System.currentTimeMillis();
        RecipeTransformer.Result result = new RecipeTransformer(this.recipeHandlerFactory, this.replacementMap, this.unifyConfig, this.duplicationConfig).transformRecipes(recipes, skipClientTracking);
        RecipeDumper dumper = new RecipeDumper(result, startTime, System.currentTimeMillis());
        dumper.dump(this.debugConfig.dumpOverview, this.debugConfig.dumpUnification, this.debugConfig.dumpDuplicates);
        this.debugConfig.logRecipes(recipes, "recipes_after_unification.txt");
        if (this.debugConfig.dumpUncoveredRecipes) {
            UncoveredRecipesDumper.write(recipes);
        }
    }

    @Override
    public Optional<TagMap<class_1792>> getFilteredTagMap() {
        return Optional.of(this.tagMap);
    }

    @Override
    public Optional<ReplacementMap> getReplacementMap() {
        return Optional.of(this.replacementMap);
    }

    @Override
    public Optional<UnifyConfig> getUnifyConfig() {
        return Optional.of(this.unifyConfig);
    }
}

