package com.almostreliable.unified.api.recipe;

public final class RecipeConstants {
    // common inputs
    public static final String ITEM = "item";
    public static final String TAG = "tag";
    public static final String INPUT = "input";
    public static final String INPUTS = "inputs";
    public static final String INGREDIENT = "ingredient";
    public static final String INGREDIENTS = "ingredients";
    public static final String INPUT_ITEMS = "inputItems";
    public static final String CATALYST = "catalyst";

    // common outputs
    public static final String OUTPUT = "output";
    public static final String OUTPUTS = "outputs";
    public static final String RESULT = "result";
    public static final String RESULTS = "results";
    public static final String OUTPUT_ITEMS = "outputItems";

    // inner keys
    public static final String VALUE = "value";
    public static final String BASE = "base";

    // ars nouveau
    public static final String PEDESTAL_ITEMS = "pedestalItems";
    public static final String REAGENT = "reagent";

    // gregtech modern
    public static final String TICK_INPUTS = "tickInputs";
    public static final String TICK_OUTPUTS = "tickOutputs";

    // immersive engineering
    public static final String INPUT_0 = "input0";
    public static final String INPUT_1 = "input1";
    public static final String ADDITIVES = "additives";
    public static final String SECONDARIES = "secondaries";
    public static final String SLAG = "slag";

    // mekanism
    public static final String MAIN_INPUT = "mainInput";
    public static final String MAIN_OUTPUT = "mainOutput";
    public static final String ITEM_INPUT = "itemInput";
    public static final String ITEM_OUTPUT = "itemOutput";
    public static final String SECONDARY_OUTPUT = "secondaryOutput";

    // modern industrialization
    public static final String ITEM_INPUTS = "item_inputs";
    public static final String ITEM_OUTPUTS = "item_outputs";

    // cyclic
    public static final String BONUS = "bonus";

    // terrafirmacraft
    public static final String STACK = "stack";
    public static final String EXTRA_PRODUCTS = "extra_products";
    public static final String FIRST_INPUT = "first_input";
    public static final String SECOND_INPUT = "second_input";
    public static final String INPUT_ITEM = "input_item";
    public static final String OUTPUT_ITEM = "input_item";
    public static final String EXTRA_DROP = "extra_drop";
    public static final String BATCH = "batch";
    public static final String RESULT_ITEM = "result_item";
    public static final String MOLD = "mold";
    public static final String PRIMARY_INGREDIENT = "primary_ingredient";
    public static final String SECONDARY_INPUT = "secondary_input";
    public static final String BASE_INGREDIENT = "base_ingredient";

    private RecipeConstants() {}
}
