package alexthw.starbunclemania.datagen;

import alexthw.starbunclemania.StarbuncleMania;
import alexthw.starbunclemania.registry.ModRegistry;
import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.common.advancement.ANCriteriaTriggers;
import com.hollingsworth.arsnouveau.common.datagen.advancement.ANAdvancementBuilder;
import com.hollingsworth.arsnouveau.common.datagen.advancement.ANAdvancements;
import com.hollingsworth.arsnouveau.common.lib.LibItemNames;
import net.minecraft.advancements.*;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class StarAdvancementsProvider extends AdvancementProvider {


    public StarAdvancementsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper existingFileHelper) {
        super(output, registries, existingFileHelper, List.of(new SBMAdvancements()));
    }

    public static class SBMAdvancements extends ANAdvancements {

        static Consumer<AdvancementHolder> advancementConsumer;

        static AdvancementHolder dummy(String name) {
            return new AdvancementHolder(ResourceLocation.fromNamespaceAndPath(ArsNouveau.MODID, name), new Advancement( Optional.empty(), Optional.empty(), AdvancementRewards.EMPTY, Map.of(), new AdvancementRequirements(List.of()) , false));
        }


        @Override
        public void generate(HolderLookup.@NotNull Provider registries, @NotNull Consumer<AdvancementHolder> con, @NotNull ExistingFileHelper existingFileHelper) {
            advancementConsumer = con;
            AdvancementHolder starbyCharm = dummy("starby_charm");
            saveBasicItem(ModRegistry.STARBUCKET.get(), starbyCharm);
            saveBasicItem(ModRegistry.STARBALLON.get(), starbyCharm);
            saveBasicItem(ModRegistry.STARBATTERY.get(), starbyCharm);
            saveBasicItem(ModRegistry.STARTRASH.get(), starbyCharm);
            saveBasicItem(ModRegistry.PROFHAT.get(), starbyCharm);

            AdvancementHolder starbyShades = dummy(LibItemNames.STARBUNCLE_SHADES);
            saveBasicItem(ModRegistry.ROBINHAT.get(), starbyShades);

            AdvancementHolder jar = dummy("source_jar");
            var fluidJar = saveBasicItem(ModRegistry.FLUID_JAR.get(), jar);
            saveBasicItem(ModRegistry.SOURCE_CONDENSER.get(), fluidJar);
            saveBasicItem(ModRegistry.FLUID_SOURCELINK.get(), fluidJar);

            AdvancementHolder wixie = dummy("wixie_charm");
            builder("wixie_cook").display(Blocks.FURNACE, AdvancementType.TASK, false).addCriterion(ANCriteriaTriggers.createCriterion(ModRegistry.WIXIE_1)).parent(wixie).save(con);
            builder("wixie_stoneworks").display(Blocks.STONECUTTER, AdvancementType.TASK, false).addCriterion(ANCriteriaTriggers.createCriterion(ModRegistry.WIXIE_2)).parent(wixie).save(con);
            builder("wixie_mixer").display(ModRegistry.MIXER_WIXIE_CAULDRON.get(), AdvancementType.TASK, false).addCriterion(ANCriteriaTriggers.createCriterion(ModRegistry.WIXIE_3)).parent(wixie).save(con);

        }

        public ANAdvancementBuilder buildBasicItem(ItemLike item, AdvancementHolder parent){
            return builder(BuiltInRegistries.ITEM.getKey(item.asItem()).getPath()).normalItemRequirement(item).parent(parent);
        }

        public AdvancementHolder saveBasicItem(ItemLike item, AdvancementHolder parent){
            return buildBasicItem(item, parent).save(advancementConsumer);
        }

        public ANAdvancementBuilder builder(String key) {
            return ANAdvancementBuilder.builder(StarbuncleMania.MODID, key);
        }

    }
}
