/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.mixin;

import alexthw.starbunclemania.registry.EidolonCompat;
import alexthw.starbunclemania.registry.FarmerDelightCompat;
import alexthw.starbunclemania.registry.ModRegistry;
import com.hollingsworth.arsnouveau.common.items.summon_charms.WixieCharm;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.StonecutterBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WixieCharm.class})
public class WixieCharmMixin {
    @Inject(method={"useOnBlock"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void useOnBlock(UseOnContext context, @NotNull Level world, BlockPos pos, CallbackInfoReturnable<InteractionResult> cir) {
        BlockState blockState = world.getBlockState(pos);
        Player player = context.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (blockState.getBlock() instanceof FurnaceBlock) {
            world.setBlockAndUpdate(pos, (BlockState)((Block)ModRegistry.SMELTING_WIXIE_CAULDRON.get()).defaultBlockState().setValue((Property)FurnaceBlock.FACING, (Comparable)((Direction)blockState.getValue((Property)FurnaceBlock.FACING))));
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
            ((PlayerTrigger)ModRegistry.WIXIE_1.get()).trigger(player2);
        } else if (blockState.getBlock() instanceof StonecutterBlock) {
            world.setBlockAndUpdate(pos, (BlockState)((Block)ModRegistry.STONEWORK_WIXIE_CAULDRON.get()).defaultBlockState().setValue((Property)StonecutterBlock.FACING, (Comparable)((Direction)blockState.getValue((Property)StonecutterBlock.FACING))));
            ((PlayerTrigger)ModRegistry.WIXIE_2.get()).trigger(player2);
            cir.setReturnValue((Object)InteractionResult.SUCCESS);
        } else {
            if (ModList.get().isLoaded("farmersdelight")) {
                FarmerDelightCompat.checkWixieBlock(blockState, world, pos, player2, cir);
            }
            if (ModList.get().isLoaded("eidolon")) {
                EidolonCompat.checkWixieBlock(blockState, world, pos, player2, cir);
            }
        }
    }
}

