/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.client;

import alexthw.starbunclemania.client.FluidSourceLinkRenderer;
import alexthw.starbunclemania.client.JarRenderer;
import alexthw.starbunclemania.client.ResizedStarbRender;
import alexthw.starbunclemania.client.SourceCondenserRenderer;
import alexthw.starbunclemania.common.data.DirectionData;
import alexthw.starbunclemania.registry.EidolonCompat;
import alexthw.starbunclemania.registry.FarmerDelightCompat;
import alexthw.starbunclemania.registry.ModRegistry;
import alexthw.starbunclemania.registry.SourceFluid;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;

@EventBusSubscriber(value={Dist.CLIENT}, modid="starbunclemania", bus=EventBusSubscriber.Bus.MOD)
@OnlyIn(value=Dist.CLIENT)
public class ClientHandler {
    @SubscribeEvent
    public static void bindRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)ModRegistry.FLUID_SOURCELINK_TILE.get(), FluidSourceLinkRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModRegistry.SOURCE_CONDENSER_TILE.get(), SourceCondenserRenderer::new);
        event.registerEntityRenderer((EntityType)ModRegistry.STARBY_MOUNT.get(), ResizedStarbRender::new);
        if (ModList.get().isLoaded("eidolon")) {
            EidolonCompat.onRegisterRenders(event);
        }
        if (ModList.get().isLoaded("farmersdelight")) {
            FarmerDelightCompat.onRegisterRenders(event);
        }
    }

    @SubscribeEvent
    public static void init(FMLClientSetupEvent evt) {
        BlockEntityRenderers.register((BlockEntityType)((BlockEntityType)ModRegistry.FLUID_JAR_TILE.get()), context -> new JarRenderer());
        evt.enqueueWork(() -> ItemProperties.register((Item)((Item)ModRegistry.DIRECTION_SCROLL.get()), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"starbunclemania", (String)"side"), (stack, level, entity, seed) -> {
            DirectionData tag = (DirectionData)stack.get(ModRegistry.DIRECTION);
            return tag != null ? (float)tag.direction().ordinal() : -1.0f;
        }));
    }

    @SubscribeEvent
    public static void registerColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> tintIndex == 0 ? ((DyedItemColor)stack.getOrDefault(DataComponents.DYED_COLOR, (Object)new DyedItemColor(0, false))).rgb() : -1, new ItemLike[]{(ItemLike)ModRegistry.STARBALLON.get()});
    }

    @SubscribeEvent
    public static void registerClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerFluidType(SourceFluid.extension, new Holder[]{ModRegistry.SOURCE_FLUID_TYPE});
    }
}

