/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.starbuncle.placer;

import alexthw.starbunclemania.starbuncle.AuthorizedBehavior;
import alexthw.starbunclemania.starbuncle.StarbyItemBehavior;
import alexthw.starbunclemania.starbuncle.TakeItemGoal;
import alexthw.starbunclemania.starbuncle.placer.PlaceBlockGoal;
import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.GoToBedGoal;
import com.hollingsworth.arsnouveau.common.entity.goal.carbuncle.StarbyBehavior;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.BlockSnapshot;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StarbyPlacerBehavior
extends StarbyItemBehavior
implements AuthorizedBehavior {
    public static final ResourceLocation MINER_ID = ResourceLocation.fromNamespaceAndPath((String)"starbunclemania", (String)"starby_block_placer");
    UUID ownerUUID;

    public StarbyPlacerBehavior(Starbuncle entity, CompoundTag tag) {
        super(entity, tag);
        if (tag.contains("ownerUUID")) {
            this.ownerUUID = tag.getUUID("ownerUUID");
        }
        this.goals.add(new WrappedGoal(1, (Goal)new GoToBedGoal(entity, (StarbyBehavior)this)));
        this.goals.add(new WrappedGoal(3, new PlaceBlockGoal<StarbyPlacerBehavior>(entity, this)));
        this.goals.add(new WrappedGoal(5, new TakeItemGoal<StarbyPlacerBehavior>(entity, this)));
    }

    public CompoundTag toTag(CompoundTag tag) {
        if (this.ownerUUID != null) {
            tag.putUUID("ownerUUID", this.ownerUUID);
        }
        return super.toTag(tag);
    }

    public void getTooltip(Consumer<Component> tooltip) {
        super.getTooltip(tooltip);
        tooltip.accept((Component)Component.translatable((String)"ars_nouveau.starbuncle.placing", (Object[])new Object[]{this.TO_LIST.size()}));
        tooltip.accept((Component)Component.translatable((String)"ars_nouveau.starbuncle.taking", (Object[])new Object[]{this.FROM_LIST.size()}));
        if (!this.itemScroll.isEmpty()) {
            tooltip.accept((Component)Component.translatable((String)"ars_nouveau.filtering_with", (Object[])new Object[]{this.itemScroll.getHoverName().getString()}));
        }
    }

    @Override
    public void setOwnerUUID(UUID ownerUUID) {
        this.ownerUUID = ownerUUID;
    }

    @Override
    @NotNull
    public UUID getOwnerUUID() {
        return this.ownerUUID == null ? ANFakePlayer.getPlayer((ServerLevel)((ServerLevel)this.starbuncle.level())).getUUID() : this.ownerUUID;
    }

    public void pickUpItem(ItemEntity itemEntity) {
        super.pickUpItem(itemEntity);
        if (this.getValidStorePos(itemEntity.getItem()) == null) {
            return;
        }
        Starbuncle starbuncleWithRoom = this.starbuncle.getStarbuncleWithSpace();
        starbuncleWithRoom.setHeldStack(itemEntity.getItem());
        itemEntity.remove(Entity.RemovalReason.DISCARDED);
        this.level.playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.ITEM_PICKUP, this.starbuncle.getSoundSource(), 1.0f, 1.0f);
        for (ItemEntity i : this.level.getEntitiesOfClass(ItemEntity.class, this.starbuncle.getBoundingBox().inflate(3.0))) {
            if (itemEntity.getItem().getCount() >= itemEntity.getItem().getMaxStackSize()) break;
            int maxTake = starbuncleWithRoom.getHeldStack().getMaxStackSize() - starbuncleWithRoom.getHeldStack().getCount();
            if (!ItemStack.isSameItemSameComponents((ItemStack)i.getItem(), (ItemStack)starbuncleWithRoom.getHeldStack())) continue;
            int toTake = Math.min(i.getItem().getCount(), maxTake);
            i.getItem().shrink(toTake);
            starbuncleWithRoom.getHeldStack().grow(toTake);
        }
    }

    public void onFinishedConnectionFirst(@Nullable BlockPos storedPos, @Nullable Direction side, @Nullable LivingEntity storedEntity, Player playerEntity) {
        super.onFinishedConnectionFirst(storedPos, side, storedEntity, playerEntity);
        if (storedPos != null && !this.level.isOutsideBuildHeight(storedPos)) {
            this.addToPos(storedPos);
            this.syncTag();
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.starbuncle.place"));
        }
    }

    public void onFinishedConnectionLast(@Nullable BlockPos storedPos, @Nullable Direction side, @Nullable LivingEntity storedEntity, Player playerEntity) {
        super.onFinishedConnectionLast(storedPos, side, storedEntity, playerEntity);
        if (storedPos != null && this.getItemCapFromTile(storedPos, side) != null) {
            this.addFromPos(storedPos);
            this.syncTag();
            PortUtil.sendMessage((Entity)playerEntity, (Component)Component.translatable((String)"ars_nouveau.starbuncle.take"));
        }
    }

    public boolean canGoToBed() {
        return this.isBedPowered() || this.getValidTakePos() == null && (this.starbuncle.getHeldStack().isEmpty() || this.getValidPlacePos(this.starbuncle.getHeldStack()) == null);
    }

    public ResourceLocation getRegistryName() {
        return MINER_ID;
    }

    @Override
    public BlockPos getValidStorePos(ItemStack stack) {
        return this.getValidPlacePos(stack);
    }

    @Nullable
    public BlockPos getValidPlacePos(ItemStack stack) {
        if (this.TO_LIST.isEmpty()) {
            return null;
        }
        Item item = stack.getItem();
        if (!(item instanceof BlockItem)) {
            return null;
        }
        BlockItem bi = (BlockItem)item;
        for (BlockPos p : this.TO_LIST) {
            if (!this.isPositionValidPlace(p, bi.getBlock())) continue;
            return p;
        }
        return null;
    }

    public boolean isPositionValidPlace(BlockPos p, Block block) {
        if (p == null || !this.level.isLoaded(p)) {
            return false;
        }
        return this.level.getBlockState(p).canBeReplaced() && this.canPlaceBlock(p) && block.defaultBlockState().canSurvive((LevelReader)this.level, p);
    }

    public boolean canPlaceBlock(BlockPos targetPos) {
        Starbuncle starbuncle;
        Level level;
        if (this.ownerUUID != null && (level = this.starbuncle.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            starbuncle = FakePlayerFactory.get((ServerLevel)serverLevel, (GameProfile)new GameProfile(this.getOwnerUUID(), ""));
        } else {
            starbuncle = this.starbuncle;
        }
        Starbuncle placerEntity = starbuncle;
        BlockEvent.EntityPlaceEvent event = (BlockEvent.EntityPlaceEvent)NeoForge.EVENT_BUS.post((Event)new BlockEvent.EntityPlaceEvent(BlockSnapshot.create((ResourceKey)this.level.dimension(), (LevelAccessor)this.level, (BlockPos)targetPos), this.level.getBlockState(targetPos), (Entity)placerEntity));
        return !event.isCanceled();
    }
}

