/*
 * Decompiled with CFR 0.152.
 */
package com.alexthw.sauce.common.entity;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnthrallUtil {
    public static final String THRALL_KEY = "sauce:thrall";

    @Nullable
    public static LivingEntity handleEnthralledTargeting(@Nullable LivingEntity lastHurt, @Nullable LivingEntity lastHurtBy, LivingEntity thrall) {
        if (lastHurtBy != null && lastHurtBy != thrall && !thrall.isAlliedTo((Entity)lastHurtBy)) {
            return lastHurtBy;
        }
        if (lastHurt != null && lastHurt != thrall && !thrall.isAlliedTo((Entity)lastHurt)) {
            return lastHurt;
        }
        if (thrall.getLastHurtByMob() != null && !thrall.isAlliedTo((Entity)thrall.getLastHurtByMob())) {
            return thrall.getLastHurtByMob();
        }
        return null;
    }

    public static boolean isEnthralled(LivingEntity entity) {
        return entity.getPersistentData().contains(THRALL_KEY);
    }

    public static boolean isEnthralledBy(LivingEntity entity, LivingEntity owner) {
        return entity != null && owner != null && EnthrallUtil.isEnthralled(entity) && entity.getPersistentData().getUUID(THRALL_KEY).equals(owner.getUUID());
    }

    public static boolean sameMaster(@NotNull LivingEntity entity, @NotNull LivingEntity source) {
        if (!EnthrallUtil.isEnthralled(entity) || !EnthrallUtil.isEnthralled(source)) {
            return false;
        }
        return entity.getPersistentData().getUUID(THRALL_KEY).equals(source.getPersistentData().getUUID(THRALL_KEY));
    }

    public static void permanentEnthrall(LivingEntity caster, LivingEntity thrall) {
        thrall.getPersistentData().putUUID(THRALL_KEY, caster.getUUID());
        if (thrall instanceof Mob) {
            Mob mob = (Mob)thrall;
            mob.setPersistenceRequired();
        }
    }
}

