/*
 * Decompiled with CFR 0.152.
 */
package com.alexthw.sauce.common.block;

import com.alexthw.sauce.common.block.FocusEnhancedSpellTurret;
import com.alexthw.sauce.mixin.TurretAccessor;
import com.alexthw.sauce.registry.ModRegistry;
import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.spell.ITurretBehavior;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.TileCaster;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.common.block.BasicSpellTurret;
import com.hollingsworth.arsnouveau.common.block.tile.RotatingTurretTile;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketOneShotAnimation;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import org.jetbrains.annotations.NotNull;

public class FocusEnhancedSpellTurretTile
extends RotatingTurretTile {
    private SpellSchool school;

    public FocusEnhancedSpellTurretTile(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    public FocusEnhancedSpellTurretTile(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModRegistry.FOCUS_TURRET.get(), pos, state);
    }

    @NotNull
    public BlockEntityType<?> getType() {
        return (BlockEntityType)ModRegistry.FOCUS_TURRET.get();
    }

    public SpellSchool getSchool() {
        return this.school;
    }

    public int getManaCost() {
        Spell spell = this.spellCaster.getSpell();
        if (spell.unsafeList().stream().anyMatch(p -> this.school.isPartOfSchool(p))) {
            return (int)((double)spell.getCost() * 0.35);
        }
        return (int)((double)spell.getCost() * 0.6);
    }

    public void shootSpell() {
        Level level;
        BlockPos pos = this.getBlockPos();
        if (this.spellCaster.getSpell().isEmpty() || !((level = this.level) instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)level;
        int manaCost = this.getManaCost();
        if (manaCost > 0 && SourceUtil.takeSourceMultiple((BlockPos)pos, (Level)world, (int)10, (int)manaCost) == null) {
            return;
        }
        Networking.sendToNearbyClient((Level)world, (BlockPos)pos, (CustomPacketPayload)new PacketOneShotAnimation(pos));
        Position iposition = BasicSpellTurret.getDispensePosition((BlockPos)pos, (Direction)((Direction)world.getBlockState(pos).getValue((Property)BasicSpellTurret.FACING)));
        Direction direction = (Direction)world.getBlockState(pos).getValue((Property)BasicSpellTurret.FACING);
        UUID uuid = ((TurretAccessor)((Object)this)).getUuid();
        ANFakePlayer fakePlayer = uuid != null ? FakePlayerFactory.get((ServerLevel)world, (GameProfile)new GameProfile(uuid, "")) : ANFakePlayer.getPlayer((ServerLevel)world);
        fakePlayer.setPos((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        FocusEnhancedSpellTurret.FocusTurretSpellResolver resolver = new FocusEnhancedSpellTurret.FocusTurretSpellResolver(new SpellContext((Level)world, this.spellCaster.getSpell(), (LivingEntity)fakePlayer, (IWrappedCaster)new TileCaster((BlockEntity)this, SpellContext.CasterType.TURRET)), this.getSchool());
        if (resolver.castType != null && BasicSpellTurret.TURRET_BEHAVIOR_MAP.containsKey(resolver.castType)) {
            ((ITurretBehavior)BasicSpellTurret.TURRET_BEHAVIOR_MAP.get(resolver.castType)).onCast((SpellResolver)resolver, world, pos, (Player)fakePlayer, iposition, direction);
        }
    }

    public FocusEnhancedSpellTurretTile setSchool(SpellSchool school) {
        this.school = school;
        return this;
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        tag.putString("school", this.school.getId());
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(tag, pRegistries);
        this.school = switch (tag.getString("school")) {
            case "fire" -> SpellSchools.ELEMENTAL_FIRE;
            case "water" -> SpellSchools.ELEMENTAL_WATER;
            case "air" -> SpellSchools.ELEMENTAL_AIR;
            case "earth" -> SpellSchools.ELEMENTAL_EARTH;
            case "conjuration" -> SpellSchools.CONJURATION;
            case "abjuration" -> SpellSchools.ABJURATION;
            case "elemental" -> SpellSchools.ELEMENTAL;
            case "necromancy" -> SpellSchools.NECROMANCY;
            default -> SpellSchools.MANIPULATION;
        };
    }
}

