/*
 * Decompiled with CFR 0.152.
 */
package com.alexthw.sauce.api.item;

import com.alexthw.sauce.api.item.ISchoolProvider;
import com.alexthw.sauce.util.CompatUtils;
import com.hollingsworth.arsnouveau.api.item.ISpellModifierItem;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotResult;

public interface ISchoolFocus
extends ISpellModifierItem,
ISchoolProvider {
    public static ISchoolFocus getFirstFocus(@NotNull Player player) {
        Item item;
        for (InteractionHand curHand : InteractionHand.values()) {
            Item hand = player.getItemInHand(curHand).getItem();
            if (!(hand instanceof ISchoolFocus)) continue;
            ISchoolFocus focus = (ISchoolFocus)hand;
            return focus;
        }
        SlotResult curio = CompatUtils.getCurio((LivingEntity)player, c -> c.getItem() instanceof ISchoolFocus);
        if (!curio.stack().isEmpty() && (item = curio.stack().getItem()) instanceof ISchoolFocus) {
            ISchoolFocus focus = (ISchoolFocus)item;
            return focus;
        }
        return null;
    }

    public static Set<SpellSchool> getFociSchools(@Nullable LivingEntity caster) {
        Item item;
        if (caster == null) {
            return Set.of();
        }
        if (caster instanceof ISchoolProvider) {
            ISchoolProvider provider = (ISchoolProvider)caster;
            return provider.getSchools();
        }
        HashSet<SpellSchool> schools = new HashSet<SpellSchool>();
        for (InteractionHand curHand : InteractionHand.values()) {
            Item hand = caster.getItemInHand(curHand).getItem();
            if (!(hand instanceof ISchoolFocus)) continue;
            ISchoolFocus focus = (ISchoolFocus)hand;
            schools.addAll(focus.getSchools());
        }
        SlotResult curio = CompatUtils.getCurio(caster, c -> c.getItem() instanceof ISchoolFocus);
        if (!curio.stack().isEmpty() && (item = curio.stack().getItem()) instanceof ISchoolFocus) {
            ISchoolFocus focus = (ISchoolFocus)item;
            schools.addAll(focus.getSchools());
        }
        return schools;
    }

    public double getDiscount();
}

