/*
 * Decompiled with CFR 0.152.
 */
package com.alexthw.sauce.api.item;

import com.alexthw.sauce.api.item.components.CharmData;
import com.alexthw.sauce.registry.ModRegistry;
import com.alexthw.sauce.util.CharmUtil;
import com.hollingsworth.arsnouveau.api.item.ArsNouveauCurio;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.NotNull;

public class AbstractCharm
extends ArsNouveauCurio {
    private final int uses;

    public AbstractCharm(Item.Properties properties, int uses) {
        super(properties.stacksTo(1).durability(uses).component(ModRegistry.CHARM_DATA, (Object)new CharmData(uses)));
        this.uses = uses;
    }

    public AbstractCharm(int uses) {
        super(ModRegistry.defaultItemProperties().stacksTo(1).durability(uses).component(ModRegistry.CHARM_DATA, (Object)new CharmData(uses)));
        this.uses = uses;
    }

    public void appendHoverText(@NotNull ItemStack stack, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip2, @NotNull TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip2, flagIn);
        tooltip2.add((Component)Component.translatable((String)"tooltip.sauce.charm.desc").withStyle(ChatFormatting.GRAY));
        int charges = CharmData.getOrDefault(stack, this.uses).charges();
        tooltip2.add((Component)Component.translatable((String)"tooltip.sauce.charm.charges", (Object[])new Object[]{charges, this.uses}).withStyle(ChatFormatting.GOLD));
        String descKey = Util.makeDescriptionId((String)"tooltip", (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this));
        tooltip2.add((Component)Component.translatable((String)descKey).withStyle(ChatFormatting.GRAY));
    }

    public int getMaxDamage(@NotNull ItemStack stack) {
        return this.uses;
    }

    public int getDamage(@NotNull ItemStack stack) {
        return this.uses - CharmData.getOrDefault(stack, this.uses).charges();
    }

    public boolean isBarVisible(@NotNull ItemStack stack) {
        int charges = CharmData.getOrDefault(stack, this.uses).charges();
        return charges != this.uses;
    }

    public boolean shouldCauseReequipAnimation(@NotNull ItemStack oldStack, @NotNull ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public boolean canElytraFly(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        return super.canElytraFly(stack, entity);
    }

    public void setDamage(@NotNull ItemStack stack, int damage) {
    }

    public boolean isRepairable(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isDamageable(@NotNull ItemStack stack) {
        return CharmUtil.isEnabled(stack);
    }
}

