/*
 * Decompiled with CFR 0.152.
 */
package com.alexthw.sauce.mixin;

import com.alexthw.sauce.Sauce;
import com.alexthw.sauce.common.entity.EnthrallUtil;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin {
    @Inject(method={"canAttack(Lnet/minecraft/world/entity/LivingEntity;)Z"}, at={@At(value="TAIL")}, cancellable=true)
    public void sauce$canAttack(LivingEntity pTarget, CallbackInfoReturnable<Boolean> cir) {
        if (!Sauce.ENABLE_ENTHRALL) {
            return;
        }
        Entity entity = (Entity)this;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (pTarget != null && EnthrallUtil.isEnthralled(living)) {
                if (living.isAlliedTo((Entity)pTarget)) {
                    cir.setReturnValue((Object)false);
                }
                UUID master = living.getPersistentData().getUUID("sauce:thrall");
                Player player = living.level().getPlayerByUUID(master);
                if (player instanceof ServerPlayer) {
                    ServerPlayer player2 = (ServerPlayer)player;
                    LivingEntity lastHurt = player2.getLastHurtMob();
                    LivingEntity lastHurtBy = player2.getLastHurtByMob();
                    if (lastHurt != pTarget && lastHurtBy != pTarget) {
                        cir.setReturnValue((Object)false);
                    }
                }
            }
        }
    }
}

