/*
 * Decompiled with CFR 0.152.
 */
package com.alexthw.sauce.common.recipe;

import com.alexthw.sauce.registry.ModRegistry;
import com.hollingsworth.arsnouveau.api.util.PerkUtil;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ApparatusRecipeInput;
import com.hollingsworth.arsnouveau.common.crafting.recipes.EnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ITextOutput;
import com.hollingsworth.arsnouveau.common.items.data.ArmorPerkHolder;
import com.hollingsworth.arsnouveau.common.util.ANCodecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ElementalArmorRecipe
extends EnchantingApparatusRecipe
implements ITextOutput {
    public int tier = 3;

    public int tier() {
        return this.tier;
    }

    public ElementalArmorRecipe(Ingredient reagent, ItemStack result, List<Ingredient> pedestalItems, int cost) {
        super(reagent, result, pedestalItems, cost, true);
    }

    public ElementalArmorRecipe(Ingredient reagent, ItemStack result, List<Ingredient> pedestalItems, int cost, int tier) {
        super(reagent, result, pedestalItems, cost, true);
        this.tier = tier;
    }

    public boolean matches(ApparatusRecipeInput input, Level level) {
        ArmorPerkHolder perkHolder = PerkUtil.getPerkHolder((ItemStack)input.catalyst());
        if (!(perkHolder instanceof ArmorPerkHolder)) {
            return false;
        }
        ArmorPerkHolder armorPerkHolder = perkHolder;
        return armorPerkHolder.getTier() == this.tier - 1 && super.matches(input, level);
    }

    @NotNull
    public ItemStack assemble(ApparatusRecipeInput input, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        ItemStack result = super.assemble(input, provider);
        if (!input.catalyst().isComponentsPatchEmpty()) {
            result.applyComponents(input.catalyst().getComponentsPatch());
            result.setDamageValue(0);
        }
        return result;
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)ModRegistry.ELEMENTAL_ARMOR_UP.get();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRegistry.ELEMENTAL_ARMOR_UP_SERIALIZER.get();
    }

    public Component getOutputComponent() {
        return Component.translatable((String)"ars_nouveau.armor_upgrade.book_desc", (Object[])new Object[]{this.tier});
    }

    public boolean excludeJei() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<ElementalArmorRecipe> {
        public static MapCodec<ElementalArmorRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("reagent").forGetter(EnchantingApparatusRecipe::reagent), (App)ItemStack.CODEC.fieldOf("result").forGetter(EnchantingApparatusRecipe::result), (App)Ingredient.CODEC.listOf().fieldOf("pedestalItems").forGetter(EnchantingApparatusRecipe::pedestalItems), (App)Codec.INT.fieldOf("sourceCost").forGetter(EnchantingApparatusRecipe::sourceCost), (App)Codec.INT.optionalFieldOf("tier", (Object)3).forGetter(recipe -> recipe.tier)).apply((Applicative)instance, ElementalArmorRecipe::new));
        public static StreamCodec<RegistryFriendlyByteBuf, ElementalArmorRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, EnchantingApparatusRecipe::reagent, (StreamCodec)ItemStack.STREAM_CODEC, EnchantingApparatusRecipe::result, (StreamCodec)ANCodecs.INGREDIENT_LIST_STREAM, EnchantingApparatusRecipe::pedestalItems, (StreamCodec)ByteBufCodecs.VAR_INT, EnchantingApparatusRecipe::sourceCost, (StreamCodec)ByteBufCodecs.VAR_INT, ElementalArmorRecipe::tier, ElementalArmorRecipe::new);

        @NotNull
        public MapCodec<ElementalArmorRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, ElementalArmorRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

