/*
 * Decompiled with CFR 0.152.
 */
package com.alexthw.sauce.common.recipe;

import com.alexthw.sauce.api.item.AbstractCharm;
import com.alexthw.sauce.registry.ModRegistry;
import com.alexthw.sauce.util.CharmUtil;
import com.hollingsworth.arsnouveau.api.imbuement_chamber.IImbuementRecipe;
import com.hollingsworth.arsnouveau.common.block.tile.ImbuementTile;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record CharmChargingRecipe(ResourceLocation id, Item input, int costPerCharge) implements IImbuementRecipe
{
    public boolean matches(ImbuementTile imbuementTile, @NotNull Level leve) {
        ItemStack reagent = imbuementTile.stack;
        Item item = reagent.getItem();
        if (item instanceof AbstractCharm) {
            AbstractCharm charm = (AbstractCharm)item;
            if (charm.getDamage(reagent) == 0) {
                return false;
            }
            return reagent.is(this.input);
        }
        return false;
    }

    @NotNull
    public ItemStack assemble(ImbuementTile imbuementTile, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        ItemStack reagent = imbuementTile.stack;
        ItemStack result = reagent.copy();
        CharmUtil.setCharges(result, result.getMaxDamage());
        return result;
    }

    public int getSourceCost(ImbuementTile imbuementTile) {
        ItemStack reagent = imbuementTile.stack;
        return reagent.getDamageValue() * this.costPerCharge;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRegistry.CHARM_CHARGING_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)ModRegistry.CHARM_CHARGING_TYPE.get();
    }

    public Component getCraftingStartedText(ImbuementTile imbuementTile) {
        return Component.translatable((String)"chat.ars_additions.charm.charging_started", (Object[])new Object[]{this.assemble(imbuementTile, (HolderLookup.Provider)imbuementTile.getLevel().registryAccess()).getHoverName()});
    }

    public Component getCraftingText(ImbuementTile imbuementTile) {
        return Component.translatable((String)"tooltip.ars_additions.charm.charging", (Object[])new Object[]{this.assemble(imbuementTile, (HolderLookup.Provider)imbuementTile.getLevel().registryAccess()).getHoverName()});
    }

    public Component getCraftingProgressText(ImbuementTile imbuementTile, int progress) {
        return Component.translatable((String)"tooltip.ars_additions.charm.charging_progress", (Object[])new Object[]{progress}).withStyle(ChatFormatting.GOLD);
    }

    public static class Serializer
    implements RecipeSerializer<CharmChargingRecipe> {
        public static final MapCodec<CharmChargingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(CharmChargingRecipe::id), (App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("item").forGetter(CharmChargingRecipe::input), (App)Codec.INT.optionalFieldOf("costPerDamage", (Object)10).forGetter(CharmChargingRecipe::costPerCharge)).apply((Applicative)instance, CharmChargingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, CharmChargingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, CharmChargingRecipe::id, (StreamCodec)ByteBufCodecs.registry((ResourceKey)Registries.ITEM), CharmChargingRecipe::input, (StreamCodec)ByteBufCodecs.INT, CharmChargingRecipe::costPerCharge, CharmChargingRecipe::new);

        @NotNull
        public MapCodec<CharmChargingRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, CharmChargingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

