/*
 * Decompiled with CFR 0.152.
 */
package com.alexthw.sauce;

import com.alexthw.sauce.ArsNouveauRegistry;
import com.alexthw.sauce.SauceConfig;
import com.alexthw.sauce.common.fluid.SourceFluid;
import com.alexthw.sauce.event.AttributeEventHandler;
import com.alexthw.sauce.event.DamageEventHandler;
import com.alexthw.sauce.event.GenericEventHandler;
import com.alexthw.sauce.registry.ModRegistry;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidInteractionRegistry;
import net.neoforged.neoforge.fluids.FluidType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="sauce")
public class Sauce {
    public static final String MODID = "sauce";
    private static final Logger LOGGER = LogManager.getLogger();
    public static boolean ENABLE_LIQUID_SOURCE = !FMLEnvironment.production;
    public static boolean ENABLE_ENTHRALL = !FMLEnvironment.production;
    public static boolean ENABLE_SPELL_CRIT = !FMLEnvironment.production;

    public Sauce(IEventBus modEventBus, ModContainer modContainer) {
        ModRegistry.registerRegistries(modEventBus);
        ArsNouveauRegistry.init();
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::doClientStuff);
        modEventBus.addListener(this::registerClientExtensions);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SauceConfig.SERVER_SPEC);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SauceConfig.COMMON_SPEC);
        modContainer.registerConfig(ModConfig.Type.STARTUP, (IConfigSpec)SauceConfig.STARTUP_SPEC);
        NeoForge.EVENT_BUS.register(DamageEventHandler.class);
        NeoForge.EVENT_BUS.register(AttributeEventHandler.class);
        NeoForge.EVENT_BUS.register(GenericEventHandler.class);
        if (FMLEnvironment.dist.isClient()) {
            new SourceFluid.FluidTypeSourceClient(modEventBus);
        }
    }

    public static ResourceLocation prefix(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    private void doClientStuff(FMLClientSetupEvent event) {
    }

    public void registerClientExtensions(RegisterClientExtensionsEvent event) {
        if (!ENABLE_LIQUID_SOURCE) {
            return;
        }
        event.registerFluidType(SourceFluid.extension, new Holder[]{ModRegistry.SOURCE_FLUID_TYPE});
    }

    private void setup(FMLCommonSetupEvent ignoredEvent) {
        ArsNouveauRegistry.postInit();
        if (!ENABLE_LIQUID_SOURCE) {
            return;
        }
        try {
            FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ModRegistry.SOURCE_FLUID_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((level, currentPos, relativePos, currentState) -> level.getFluidState(relativePos).getFluidType() == NeoForgeMod.LAVA_TYPE.value() && level.getBlockState(currentPos.below()).is(Blocks.BLUE_ICE), Objects.requireNonNull((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"ars_nouveau", (String)"smooth_sourcestone"))).defaultBlockState()));
            FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ModRegistry.SOURCE_FLUID_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((level, currentPos, relativePos, currentState) -> level.getFluidState(relativePos).getFluidType() == NeoForgeMod.LAVA_TYPE.value(), Objects.requireNonNull((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"ars_nouveau", (String)"sourcestone"))).defaultBlockState()));
        }
        catch (NullPointerException npe) {
            System.out.println("Sourcestone not found, skipping interaction.");
        }
    }
}

