/*
 * Decompiled with CFR 0.152.
 */
package com.alexthw.sauce.event;

import com.alexthw.sauce.Sauce;
import com.alexthw.sauce.common.entity.EnthrallUtil;
import com.alexthw.sauce.common.entity.FollowOwnerGoal;
import com.alexthw.sauce.common.entity.ThrallTargetGoal;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;

public class GenericEventHandler {
    @SubscribeEvent
    public static void onEnthrallTarget(LivingChangeTargetEvent event) {
        if (!EnthrallUtil.isEnthralled(event.getEntity())) {
            return;
        }
        UUID master = event.getEntity().getPersistentData().getUUID("sauce:thrall");
        LivingEntity newTarget = null;
        if (EnthrallUtil.isEnthralledBy(event.getEntity(), event.getNewAboutToBeSetTarget())) {
            lastHurt = event.getNewAboutToBeSetTarget().getLastHurtMob();
            LivingEntity lastHurtBy = event.getNewAboutToBeSetTarget().getLastHurtByMob();
            newTarget = EnthrallUtil.handleEnthralledTargeting(lastHurt, lastHurtBy, event.getEntity());
        } else {
            ServerLevel server;
            lastHurt = event.getEntity().level();
            if (lastHurt instanceof ServerLevel && (lastHurt = (server = (ServerLevel)lastHurt).getEntity(master)) instanceof LivingEntity) {
                LivingEntity living = lastHurt;
                lastHurt = living.getLastHurtMob();
                LivingEntity lastHurtBy = living.getLastHurtByMob();
                newTarget = EnthrallUtil.handleEnthralledTargeting(lastHurt, lastHurtBy, event.getEntity());
            }
        }
        if (newTarget == null) {
            event.setNewAboutToBeSetTarget(null);
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof NeutralMob) {
                NeutralMob angry = (NeutralMob)livingEntity;
                angry.setRemainingPersistentAngerTime(0);
            }
        } else {
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof NeutralMob) {
                NeutralMob angry = (NeutralMob)livingEntity;
                angry.setPersistentAngerTarget(newTarget.getUUID());
            }
        }
    }

    @SubscribeEvent
    public static void registerCustomAI(EntityJoinLevelEvent event) {
        PathfinderMob mob;
        Entity entity;
        if (!Sauce.ENABLE_ENTHRALL) {
            return;
        }
        if (event.getEntity() instanceof LivingEntity && !event.getLevel().isClientSide && (entity = event.getEntity()) instanceof PathfinderMob && ((mob = (PathfinderMob)entity).getNavigation() instanceof GroundPathNavigation || mob.getNavigation() instanceof FlyingPathNavigation)) {
            try {
                mob.goalSelector.addGoal(2, (Goal)new FollowOwnerGoal((Mob)mob, 1.5, 3.0f, 1.2f));
                mob.targetSelector.addGoal(1, (Goal)new ThrallTargetGoal(mob));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }
}

