/*
 * Decompiled with CFR 0.152.
 */
package com.alexthw.sauce.common.recipe.jei;

import com.alexthw.sauce.common.recipe.CharmChargingRecipe;
import com.alexthw.sauce.common.recipe.ElementalArmorRecipe;
import com.alexthw.sauce.common.recipe.jei.CharmChargingRecipeCategory;
import com.alexthw.sauce.common.recipe.jei.ElementalUpgradeRecipeCategory;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JeiSaucePlugin
implements IModPlugin {
    public static final RecipeType<ElementalArmorRecipe> ELEMENTAL_ARMOR_TYPE = RecipeType.create((String)"sauce", (String)"armor_upgrade", ElementalArmorRecipe.class);
    public static final RecipeType<CharmChargingRecipe> CHARM_CHARGING_RECIPE_TYPE = RecipeType.create((String)"sauce", (String)"charm_charging", CharmChargingRecipe.class);

    @NotNull
    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"sauce", (String)"main");
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new ElementalUpgradeRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new CharmChargingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(@NotNull IRecipeRegistration registry) {
        assert (Minecraft.getInstance().level != null);
        RecipeManager manager = Minecraft.getInstance().level.getRecipeManager();
        ArrayList<ElementalArmorRecipe> armorRecipes = new ArrayList<ElementalArmorRecipe>();
        ArrayList<CharmChargingRecipe> charmChargingRecipes = new ArrayList<CharmChargingRecipe>();
        for (RecipeHolder i : manager.getRecipes()) {
            Recipe recipe;
            Objects.requireNonNull(i.value());
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CharmChargingRecipe.class, ElementalArmorRecipe.class}, (Object)recipe, n)) {
                case 0: {
                    CharmChargingRecipe recipe2 = (CharmChargingRecipe)recipe;
                    charmChargingRecipes.add(recipe2);
                    break;
                }
                case 1: {
                    ElementalArmorRecipe recipe3 = (ElementalArmorRecipe)recipe;
                    armorRecipes.add(recipe3);
                    break;
                }
            }
        }
        registry.addRecipes(ELEMENTAL_ARMOR_TYPE, armorRecipes);
        registry.addRecipes(CHARM_CHARGING_RECIPE_TYPE, charmChargingRecipes);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.ENCHANTING_APP_BLOCK), new RecipeType[]{ELEMENTAL_ARMOR_TYPE});
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.IMBUEMENT_BLOCK), new RecipeType[]{CHARM_CHARGING_RECIPE_TYPE});
    }
}

