/*
 * Decompiled with CFR 0.152.
 */
package com.alexthw.sauce.api;

import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.TileCaster;
import com.hollingsworth.arsnouveau.common.block.BasicSpellTurret;
import com.hollingsworth.arsnouveau.common.block.RuneBlock;
import com.hollingsworth.arsnouveau.common.block.tile.BasicSpellTurretTile;
import com.hollingsworth.arsnouveau.common.block.tile.RotatingTurretTile;
import com.hollingsworth.arsnouveau.common.block.tile.RuneTile;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public interface IPropagator {
    public static final AbstractAugment DUMMY = AugmentDampen.INSTANCE;

    @Nullable
    default public AbstractCastMethod getCastType() {
        return null;
    }

    public static Vec3 getDirection(LivingEntity shooter, SpellResolver resolver, Vec3 pos) {
        Vec3 direction = pos.subtract(shooter.position());
        IWrappedCaster iWrappedCaster = resolver.spellContext.getCaster();
        if (iWrappedCaster instanceof TileCaster) {
            TileCaster tc = (TileCaster)iWrappedCaster;
            BlockEntity blockEntity = tc.getTile();
            if (blockEntity instanceof RotatingTurretTile) {
                RotatingTurretTile rotatingTurretTile = (RotatingTurretTile)blockEntity;
                direction = rotatingTurretTile.getShootAngle();
            } else if (tc.getTile() instanceof BasicSpellTurretTile) {
                direction = new Vec3(((Direction)tc.getTile().getBlockState().getValue((Property)BasicSpellTurret.FACING)).step());
            } else if (tc.getTile() instanceof RuneTile) {
                direction = new Vec3(((Direction)tc.getTile().getBlockState().getValue((Property)RuneBlock.FACING)).step());
            }
        }
        return direction;
    }

    default public void copyResolver(HitResult rayTraceResult, Level world, @Nullable LivingEntity shooter, SpellStats stats, SpellContext spellContext, SpellResolver resolver) {
        SpellContext newContext = spellContext.makeChildContext();
        Spell.Mutable mutable_spell = newContext.getSpell().mutable();
        mutable_spell.recipe.addFirst(DUMMY);
        newContext.withSpell(mutable_spell.immutable());
        SpellResolver newResolver = resolver.getNewResolver(newContext);
        spellContext.setCanceled(true);
        AbstractCastMethod newCastType = this.getCastType();
        if (newCastType != null) {
            newResolver.castType = newCastType;
        }
        this.propagate(world, rayTraceResult, shooter, stats, newResolver);
    }

    public void propagate(Level var1, HitResult var2, LivingEntity var3, SpellStats var4, SpellResolver var5);
}

