/*
 * Decompiled with CFR 0.152.
 */
package com.alexthw.sauce.event;

import com.alexthw.sauce.Sauce;
import com.alexthw.sauce.registry.ModRegistry;
import com.hollingsworth.arsnouveau.api.event.SpellCostCalcEvent;
import com.hollingsworth.arsnouveau.api.event.SpellDamageEvent;
import com.hollingsworth.arsnouveau.api.event.SpellModifierEvent;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.LivingCaster;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.util.FakePlayer;

public class AttributeEventHandler {
    static Map<SpellSchool, Holder<Attribute>> schoolToAttribute = new ConcurrentHashMap<SpellSchool, Holder<Attribute>>();

    public static void linkSchoolToAttribute(SpellSchool school, Holder<Attribute> attribute) {
        schoolToAttribute.put(school, attribute);
    }

    @SubscribeEvent
    public static void discountSpell(SpellCostCalcEvent event) {
        IWrappedCaster iWrappedCaster = event.context.getCaster();
        if (iWrappedCaster instanceof LivingCaster) {
            AttributeInstance perk;
            Player player;
            LivingCaster caster = (LivingCaster)iWrappedCaster;
            LivingEntity livingEntity = caster.livingEntity;
            if (livingEntity instanceof Player && !((player = (Player)livingEntity) instanceof FakePlayer) && (perk = player.getAttribute(ModRegistry.MANA_DISCOUNT)) != null) {
                event.currentCost -= (int)perk.getValue();
            }
        }
    }

    @SubscribeEvent
    public static void critChance(SpellDamageEvent.Pre pre) {
        Player player;
        if (!Sauce.ENABLE_SPELL_CRIT) {
            return;
        }
        LivingEntity livingEntity = pre.caster;
        if (livingEntity instanceof Player && !((player = (Player)livingEntity) instanceof FakePlayer)) {
            double chance;
            AttributeInstance critChance = player.getAttribute(ModRegistry.SPELL_CRIT);
            AttributeInstance critDamage = player.getAttribute(ModRegistry.SPELL_CRIT_DAMAGE);
            if (critChance != null && critDamage != null && (chance = critChance.getValue()) > 0.0 && pre.caster.getRandom().nextDouble() < chance / 100.0) {
                pre.damage *= (float)(1.0 + critDamage.getValue() / 100.0);
            }
        }
    }

    @SubscribeEvent
    public static void empowerBySchool(SpellModifierEvent event) {
        List schools = event.spellPart.spellSchools;
        if (schools.isEmpty()) {
            return;
        }
        for (SpellSchool school : schools) {
            AttributeEventHandler.empowerSchool(event, school);
            for (SpellSchool subSchool : school.getSubSchools()) {
                AttributeEventHandler.empowerSchool(event, subSchool);
            }
        }
    }

    private static void empowerSchool(SpellModifierEvent event, SpellSchool school) {
        Holder<Attribute> attribute = schoolToAttribute.get(school);
        if (attribute != null && event.caster != null) {
            double power;
            double d = power = event.caster.getAttributes().hasAttribute(attribute) ? event.caster.getAttributeValue(attribute) : 0.0;
            if (power != 0.0) {
                event.builder.addDamageModifier(power);
            }
        }
    }

    static {
        AttributeEventHandler.linkSchoolToAttribute(SpellSchools.MANIPULATION, ModRegistry.MANIPULATION_POWER);
        AttributeEventHandler.linkSchoolToAttribute(SpellSchools.CONJURATION, ModRegistry.SUMMON_POWER);
        AttributeEventHandler.linkSchoolToAttribute(SpellSchools.ABJURATION, ModRegistry.ABJURATION_POWER);
        AttributeEventHandler.linkSchoolToAttribute(SpellSchools.NECROMANCY, ModRegistry.NECROMANCY_POWER);
        AttributeEventHandler.linkSchoolToAttribute(SpellSchools.ELEMENTAL_AIR, ModRegistry.AIR_POWER);
        AttributeEventHandler.linkSchoolToAttribute(SpellSchools.ELEMENTAL_WATER, ModRegistry.WATER_POWER);
        AttributeEventHandler.linkSchoolToAttribute(SpellSchools.ELEMENTAL_EARTH, ModRegistry.EARTH_POWER);
        AttributeEventHandler.linkSchoolToAttribute(SpellSchools.ELEMENTAL_FIRE, ModRegistry.FIRE_POWER);
        AttributeEventHandler.linkSchoolToAttribute(SpellSchools.ELEMENTAL, ModRegistry.ELEMENTAL_POWER);
    }
}

