/*
 * Decompiled with CFR 0.152.
 */
package com.alexthw.sauce.common.recipe.jei;

import com.alexthw.sauce.common.recipe.ElementalArmorRecipe;
import com.alexthw.sauce.common.recipe.jei.ElementalUpgradeRecipeCategory;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import java.util.ArrayList;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JeiArsExtraPlugin
implements IModPlugin {
    public static final RecipeType<ElementalArmorRecipe> ELEMENTAL_ARMOR_TYPE = RecipeType.create((String)"sauce", (String)"armor_upgrade", ElementalArmorRecipe.class);

    @NotNull
    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"sauce", (String)"main");
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new ElementalUpgradeRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(@NotNull IRecipeRegistration registry) {
        assert (Minecraft.getInstance().level != null);
        RecipeManager manager = Minecraft.getInstance().level.getRecipeManager();
        ArrayList<ElementalArmorRecipe> armorRecipes = new ArrayList<ElementalArmorRecipe>();
        for (RecipeHolder i : manager.getRecipes()) {
            Recipe recipe = i.value();
            if (!(recipe instanceof ElementalArmorRecipe)) continue;
            ElementalArmorRecipe aer = (ElementalArmorRecipe)recipe;
            armorRecipes.add(aer);
        }
        registry.addRecipes(ELEMENTAL_ARMOR_TYPE, armorRecipes);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst(new ItemStack((ItemLike)BlockRegistry.ENCHANTING_APP_BLOCK), new RecipeType[]{ELEMENTAL_ARMOR_TYPE});
    }
}

