/*
 * Decompiled with CFR 0.152.
 */
package com.alexthw.sauce.event;

import com.alexthw.sauce.api.item.IElementalArmor;
import com.alexthw.sauce.api.item.ISchoolFocus;
import com.alexthw.sauce.registry.ModRegistry;
import com.hollingsworth.arsnouveau.api.entity.ISummon;
import com.hollingsworth.arsnouveau.api.event.SpellDamageEvent;
import com.hollingsworth.arsnouveau.api.spell.IFilter;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.common.capability.ManaCap;
import com.hollingsworth.arsnouveau.common.entity.EnchantedFallingBlock;
import com.hollingsworth.arsnouveau.common.entity.EntityEvokerFangs;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import com.hollingsworth.arsnouveau.setup.registry.ModPotions;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;

public class DamageEventHandler {
    @SubscribeEvent
    public static void betterFilters(SpellDamageEvent.Pre event) {
        IFilter filter;
        Object e;
        if (event.context != null && event.context.getCurrentIndex() > 1 && (e = event.context.getSpell().unsafeList().get(event.context.getCurrentIndex() - 2)) instanceof IFilter && !(filter = (IFilter)e).shouldResolveOnEntity(event.target, event.target.level())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void damageTweaking(LivingIncomingDamageEvent event) {
        boolean not_bypassEnchants;
        Entity dealer = event.getSource().getEntity();
        LivingEntity target = event.getEntity();
        HashMap<SpellSchool, Integer> bonusMap = new HashMap<SpellSchool, Integer>();
        int bonusReduction = 0;
        for (ItemStack stack : event.getEntity().getArmorSlots()) {
            IElementalArmor armor;
            Item item = stack.getItem();
            if (!(item instanceof IElementalArmor) || !(armor = (IElementalArmor)item).fillAbsorptions(event.getSource(), bonusMap)) continue;
            ++bonusReduction;
        }
        boolean bl = not_bypassEnchants = !event.getSource().is(DamageTypeTags.BYPASSES_ENCHANTMENTS);
        if (target instanceof Player) {
            Set<SpellSchool> schools = ISchoolFocus.getFociSchools(target);
            if (not_bypassEnchants) {
                ManaCap mana;
                if (event.getSource().is(DamageTypes.FLY_INTO_WALL) && schools.contains(SpellSchools.ELEMENTAL_AIR)) {
                    event.setAmount(event.getAmount() * 0.1f);
                }
                if (bonusMap.getOrDefault(SpellSchools.ELEMENTAL_FIRE, 0) == 4 && event.getSource().is(DamageTypeTags.IS_FIRE)) {
                    target.clearFire();
                    if (schools.contains(SpellSchools.ELEMENTAL_FIRE)) {
                        target.addEffect(new MobEffectInstance((Holder)ModPotions.SPELL_DAMAGE_EFFECT, 200, 2));
                    }
                }
                if (bonusMap.getOrDefault(SpellSchools.ELEMENTAL_WATER, 0) == 4 && event.getSource().is(DamageTypes.DROWN)) {
                    target.setAirSupply(target.getMaxAirSupply());
                    bonusReduction += 5;
                }
                if (target instanceof Player) {
                    Player player = (Player)target;
                    if (bonusMap.getOrDefault(SpellSchools.ELEMENTAL_EARTH, 0) == 4 && target.getEyePosition().y() < 20.0 && player.getFoodData().getFoodLevel() < 4) {
                        player.getFoodData().setFoodLevel(20);
                    }
                }
                if (bonusMap.getOrDefault(SpellSchools.ELEMENTAL_AIR, 0) == 4 && event.getSource().is(DamageTypeTags.IS_FALL)) {
                    bonusReduction += 5;
                }
                if (bonusReduction > 0 && (mana = CapabilityRegistry.getMana((LivingEntity)target)) != null) {
                    if (bonusReduction > 3) {
                        mana.addMana((double)(event.getOriginalAmount() * 5.0f));
                    }
                    event.getEntity().addEffect(new MobEffectInstance((Holder)ModPotions.MANA_REGEN_EFFECT, 200, bonusReduction / 2));
                }
            }
        }
        if (bonusReduction > 0 && not_bypassEnchants) {
            event.setAmount(event.getAmount() * (1.0f - (float)bonusReduction / 10.0f));
        }
    }

    @SubscribeEvent
    public static void empowerEntitiesBySchool(LivingDamageEvent.Pre event) {
        Entity sourceEntity = event.getSource().getEntity();
        if (sourceEntity == null || !(sourceEntity.level() instanceof ServerLevel)) {
            return;
        }
        Entity entity = sourceEntity;
        Objects.requireNonNull(entity);
        Entity entity2 = entity;
        int n = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ISummon.class, EnchantedFallingBlock.class, EntityEvokerFangs.class}, (Object)entity2, n)) {
                case 0: {
                    ISummon summon = (ISummon)entity2;
                    LivingEntity livingEntity = summon.getOwner();
                    if (!(livingEntity instanceof Player)) {
                        n = 1;
                        continue block5;
                    }
                    Player player = (Player)livingEntity;
                    event.setNewDamage((float)((double)event.getNewDamage() + player.getAttributeValue(ModRegistry.SUMMON_POWER)));
                    break block5;
                }
                case 1: {
                    EnchantedFallingBlock fallingBlock = (EnchantedFallingBlock)entity2;
                    Entity entity3 = fallingBlock.getOwner();
                    if (!(entity3 instanceof Player)) {
                        n = 2;
                        continue block5;
                    }
                    Player player = (Player)entity3;
                    event.setNewDamage((float)((double)event.getNewDamage() + player.getAttributeValue(ModRegistry.MANIPULATION_POWER)));
                    break block5;
                }
                case 2: {
                    EntityEvokerFangs fangs = (EntityEvokerFangs)entity2;
                    LivingEntity livingEntity = fangs.getOwner();
                    if (!(livingEntity instanceof Player)) {
                        n = 3;
                        continue block5;
                    }
                    Player player = (Player)livingEntity;
                    event.setNewDamage((float)((double)event.getNewDamage() + player.getAttributeValue(ModRegistry.SUMMON_POWER)));
                    break block5;
                }
            }
            break;
        }
    }
}

