/*
 * Decompiled with CFR 0.152.
 */
package com.alexthw.sauce.common.fluid;

import com.alexthw.sauce.registry.ModRegistry;
import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class SourceFluid
extends FluidType {
    public static IClientFluidTypeExtensions extension = new IClientFluidTypeExtensions(){
        private static final ResourceLocation STILL = ResourceLocation.fromNamespaceAndPath((String)"sauce", (String)"block/source_still");
        private static final ResourceLocation FLOW = ResourceLocation.fromNamespaceAndPath((String)"sauce", (String)"block/source_flow");
        private static final ResourceLocation OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"ars_nouveau", (String)"block/sourcestone");
        private static final ResourceLocation VIEW_OVERLAY = ResourceLocation.fromNamespaceAndPath((String)"ars_nouveau", (String)"textures/block/sourcestone.png");

        @NotNull
        public ResourceLocation getStillTexture() {
            return STILL;
        }

        @NotNull
        public ResourceLocation getFlowingTexture() {
            return FLOW;
        }

        public ResourceLocation getOverlayTexture() {
            return OVERLAY;
        }

        public ResourceLocation getRenderOverlayTexture(@NotNull Minecraft mc) {
            return VIEW_OVERLAY;
        }

        public int getTintColor() {
            return -4891928;
        }

        @NotNull
        public Vector3f modifyFogColor(@NotNull Camera camera, float partialTick, @NotNull ClientLevel level, int renderDistance, float darkenWorldAmount, @NotNull Vector3f fluidFogColor) {
            int color = this.getTintColor();
            return new Vector3f((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
        }

        public void modifyFogRender(@NotNull Camera camera, // Could not load outer class - annotation placement on inner may be incorrect
         @NotNull FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, @NotNull FogShape shape) {
            nearDistance = -8.0f;
            farDistance = 24.0f;
            if (farDistance > renderDistance) {
                farDistance = renderDistance;
                shape = FogShape.CYLINDER;
            }
            RenderSystem.setShaderFogStart((float)nearDistance);
            RenderSystem.setShaderFogEnd((float)farDistance);
            RenderSystem.setShaderFogShape((FogShape)shape);
        }
    };

    public SourceFluid() {
        super(FluidType.Properties.create().supportsBoating(true).canHydrate(true).density(1).temperature(1).viscosity(1));
    }

    public static class FluidTypeSourceClient {
        public FluidTypeSourceClient(IEventBus modEventBus) {
            modEventBus.addListener(this::clientSetup);
            modEventBus.addListener(this::registerBlockColors);
        }

        public void clientSetup(FMLClientSetupEvent ignoredEvent) {
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModRegistry.SOURCE_FLUID.get()), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)ModRegistry.SOURCE_FLUID_FLOWING.get()), (RenderType)RenderType.translucent());
        }

        private void registerBlockColors(RegisterColorHandlersEvent.Block event) {
            event.register((state, getter, pos, index) -> {
                if (getter != null && pos != null) {
                    FluidState fluidState = getter.getFluidState(pos);
                    return IClientFluidTypeExtensions.of((FluidState)fluidState).getTintColor(fluidState, getter, pos);
                }
                return -1350565932;
            }, new Block[]{(Block)ModRegistry.SOURCE_FLUID_BLOCK.get()});
        }
    }
}

