/*
 * Decompiled with CFR 0.152.
 */
package com.alexthw.sauce.registry;

import com.alexthw.sauce.Sauce;
import com.alexthw.sauce.api.item.components.CharmData;
import com.alexthw.sauce.api.item.components.SchoolCasterTomeData;
import com.alexthw.sauce.common.fluid.SourceFluid;
import com.alexthw.sauce.common.item.ExampleCosmetic;
import com.alexthw.sauce.common.recipe.CharmChargingRecipe;
import com.alexthw.sauce.common.recipe.ElementalArmorRecipe;
import com.hollingsworth.arsnouveau.ArsNouveau;
import com.hollingsworth.arsnouveau.api.perk.PerkAttributes;
import com.hollingsworth.arsnouveau.api.sound.SpellSound;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ModRegistry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.createItems((String)"sauce");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.createBlocks((String)"sauce");
    public static final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((ResourceKey)Registries.SOUND_EVENT, (String)"sauce");
    public static final DeferredRegister<Attribute> ATTRIBUTES = DeferredRegister.create((ResourceKey)Registries.ATTRIBUTE, (String)"sauce");
    private static final DeferredRegister<FluidType> FLUID_TYPES = DeferredRegister.create((Registry)NeoForgeRegistries.FLUID_TYPES, (String)"sauce");
    private static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((Registry)BuiltInRegistries.FLUID, (String)"sauce");
    public static final DeferredRegister<RecipeType<?>> RECIPES = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_TYPE, (String)"sauce");
    public static final DeferredRegister<RecipeSerializer<?>> SERIALIZERS = DeferredRegister.create((Registry)BuiltInRegistries.RECIPE_SERIALIZER, (String)"sauce");
    public static final DeferredRegister<DataComponentType<?>> DATA_COMPONENT_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.DATA_COMPONENT_TYPE, (String)"sauce");
    public static final DeferredRegister<MapCodec<? extends ICondition>> CONDITION_CODECS = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.CONDITION_CODECS, (String)"sauce");
    public static final DeferredHolder<Item, ? extends Item> EXAMPLE;
    public static DeferredHolder<SoundEvent, SoundEvent> EXAMPLE_FAMILY;
    public static SpellSound EXAMPLE_SPELL_SOUND;
    public static final DeferredHolder<FluidType, FluidType> SOURCE_FLUID_TYPE;
    public static final DeferredHolder<Fluid, Fluid> SOURCE_FLUID;
    public static final DeferredHolder<Fluid, FlowingFluid> SOURCE_FLUID_FLOWING;
    public static final DeferredHolder<Block, LiquidBlock> SOURCE_FLUID_BLOCK;
    public static final DeferredHolder<Item, Item> SOURCE_FLUID_BUCKET;
    public static final DeferredHolder<Attribute, Attribute> SUMMON_POWER;
    public static final DeferredHolder<Attribute, Attribute> ABJURATION_POWER;
    public static final DeferredHolder<Attribute, Attribute> NECROMANCY_POWER;
    public static final DeferredHolder<Attribute, Attribute> MANIPULATION_POWER;
    public static final DeferredHolder<Attribute, Attribute> AIR_POWER;
    public static final DeferredHolder<Attribute, Attribute> EARTH_POWER;
    public static final DeferredHolder<Attribute, Attribute> FIRE_POWER;
    public static final DeferredHolder<Attribute, Attribute> WATER_POWER;
    public static final DeferredHolder<Attribute, Attribute> ELEMENTAL_POWER;
    public static final DeferredHolder<Attribute, Attribute> MANA_DISCOUNT;
    public static final DeferredHolder<RecipeType<?>, RecipeType<ElementalArmorRecipe>> ELEMENTAL_ARMOR_UP;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<ElementalArmorRecipe>> ELEMENTAL_ARMOR_UP_SERIALIZER;
    public static final DeferredHolder<RecipeType<?>, RecipeType<CharmChargingRecipe>> CHARM_CHARGING_TYPE;
    public static final DeferredHolder<RecipeSerializer<?>, RecipeSerializer<CharmChargingRecipe>> CHARM_CHARGING_SERIALIZER;
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<SchoolCasterTomeData>> E_TOME_CASTER;
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<CharmData>> CHARM_DATA;

    public static void registerRegistries(IEventBus bus) {
        BLOCKS.register(bus);
        ITEMS.register(bus);
        SOUNDS.register(bus);
        ATTRIBUTES.register(bus);
        FLUID_TYPES.register(bus);
        FLUIDS.register(bus);
        RECIPES.register(bus);
        SERIALIZERS.register(bus);
        CONDITION_CODECS.register(bus);
        DATA_COMPONENT_TYPES.register(bus);
        ATTRIBUTES.addAlias(ArsNouveau.prefix((String)"ars_elemental.perk.summon_power"), ArsNouveau.prefix((String)"sauce.perk.summon_power"));
        ATTRIBUTES.addAlias(ResourceLocation.fromNamespaceAndPath((String)"not_enough_glyphs", (String)"not_enough_glyphs.perk.mana_discount"), ArsNouveau.prefix((String)"sauce.perk.mana_discount"));
        if (Sauce.ENABLE_LIQUID_SOURCE) {
            FLUIDS.addAlias(ResourceLocation.fromNamespaceAndPath((String)"starbunclemania", (String)"source_fluid"), Sauce.prefix("source_fluid"));
            FLUIDS.addAlias(ResourceLocation.fromNamespaceAndPath((String)"starbunclemania", (String)"source_fluid_flowing"), Sauce.prefix("source_fluid_flowing"));
            BLOCKS.addAlias(ResourceLocation.fromNamespaceAndPath((String)"starbunclemania", (String)"source_fluid_block"), Sauce.prefix("source_fluid_block"));
            ITEMS.addAlias(ResourceLocation.fromNamespaceAndPath((String)"starbunclemania", (String)"source_fluid_bucket"), Sauce.prefix("source_fluid_bucket"));
        }
        DATA_COMPONENT_TYPES.addAlias(ResourceLocation.fromNamespaceAndPath((String)"ars_elemental", (String)"elemental_tome_caster"), Sauce.prefix("school_tome_caster"));
        DATA_COMPONENT_TYPES.addAlias(ResourceLocation.fromNamespaceAndPath((String)"ars_additions", (String)"charm_data"), Sauce.prefix("charm_data"));
    }

    static SoundEvent makeSound(@NotNull String name) {
        return SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"sauce", (String)name));
    }

    static Item.Properties basicItemProperties() {
        return new Item.Properties();
    }

    private static BaseFlowingFluid.Properties fluidProperties() {
        return new BaseFlowingFluid.Properties(SOURCE_FLUID_TYPE, SOURCE_FLUID, SOURCE_FLUID_FLOWING).block(SOURCE_FLUID_BLOCK).bucket(SOURCE_FLUID_BUCKET);
    }

    public static Item.Properties defaultItemProperties() {
        return new Item.Properties();
    }

    static {
        EXAMPLE_FAMILY = SOUNDS.register("example_sound", () -> ModRegistry.makeSound("example_sound"));
        EXAMPLE_SPELL_SOUND = new SpellSound(EXAMPLE_FAMILY, (Component)Component.literal((String)"Example"), Sauce.prefix("example_random_sound"));
        EXAMPLE = ITEMS.register("star_hat", () -> new ExampleCosmetic(new Item.Properties()));
        SOURCE_FLUID_TYPE = Sauce.ENABLE_LIQUID_SOURCE ? FLUID_TYPES.register("source_fluid", SourceFluid::new) : null;
        SOURCE_FLUID = Sauce.ENABLE_LIQUID_SOURCE ? FLUIDS.register("source_fluid", () -> new BaseFlowingFluid.Source(ModRegistry.fluidProperties())) : null;
        SOURCE_FLUID_FLOWING = Sauce.ENABLE_LIQUID_SOURCE ? FLUIDS.register("source_fluid_flowing", () -> new BaseFlowingFluid.Flowing(ModRegistry.fluidProperties())) : null;
        SOURCE_FLUID_BLOCK = Sauce.ENABLE_LIQUID_SOURCE ? BLOCKS.register("source_fluid_block", () -> new LiquidBlock((FlowingFluid)SOURCE_FLUID_FLOWING.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WATER).noCollission().strength(100.0f).noLootTable())) : null;
        SOURCE_FLUID_BUCKET = Sauce.ENABLE_LIQUID_SOURCE ? ITEMS.register("source_fluid_bucket", () -> new BucketItem((Fluid)SOURCE_FLUID.get(), ModRegistry.basicItemProperties().craftRemainder(Items.BUCKET).stacksTo(1))) : null;
        SUMMON_POWER = PerkAttributes.registerAttribute((String)"sauce.perk.summon_power", id -> new RangedAttribute(id, 0.0, -10000.0, 10000.0), (String)"ee3a4090-c5f5-4a26-a9c2-6044e9e609de");
        ABJURATION_POWER = PerkAttributes.registerAttribute((String)"sauce.perk.abjuration_power", id -> new RangedAttribute(id, 0.0, -10000.0, 10000.0), (String)"a1b2c3d4-e5f6-4a1b-9c8d-1234567890ab");
        NECROMANCY_POWER = PerkAttributes.registerAttribute((String)"sauce.perk.necromancy_power", id -> new RangedAttribute(id, 0.0, -10000.0, 10000.0), (String)"b2c3d4e5-f6a1-4b9c-8d12-234567890abc");
        MANIPULATION_POWER = PerkAttributes.registerAttribute((String)"sauce.perk.manipulation_power", id -> new RangedAttribute(id, 0.0, -10000.0, 10000.0), (String)"c3d4e5f6-a1b2-4c9d-8e12-34567890abcd");
        AIR_POWER = PerkAttributes.registerAttribute((String)"sauce.perk.air_power", id -> new RangedAttribute(id, 0.0, -10000.0, 10000.0), (String)"d4e5f6a1-b2c3-4d9e-8f12-4567890abcde");
        EARTH_POWER = PerkAttributes.registerAttribute((String)"sauce.perk.earth_power", id -> new RangedAttribute(id, 0.0, -10000.0, 10000.0), (String)"e5f6a1b2-c3d4-4e9f-8012-567890abcdef");
        FIRE_POWER = PerkAttributes.registerAttribute((String)"sauce.perk.fire_power", id -> new RangedAttribute(id, 0.0, -10000.0, 10000.0), (String)"f6a1b2c3-d4e5-4f90-8112-67890abcdef0");
        WATER_POWER = PerkAttributes.registerAttribute((String)"sauce.perk.water_power", id -> new RangedAttribute(id, 0.0, -10000.0, 10000.0), (String)"a7b8c9d0-e1f2-4a91-8212-7890abcdef01");
        ELEMENTAL_POWER = PerkAttributes.registerAttribute((String)"sauce.perk.elemental_power", id -> new RangedAttribute(id, 0.0, -10000.0, 10000.0), (String)"b8c9d0e1-f2a3-4b92-8312-890abcdef012");
        MANA_DISCOUNT = PerkAttributes.registerAttribute((String)"sauce.perk.mana_discount", id -> new RangedAttribute(id, 0.0, -1.7976931348623157E308, Double.MAX_VALUE).setSyncable(true), (String)"c9d0e1f2-a3b4-4c93-8412-90abcdef0123");
        ELEMENTAL_ARMOR_UP = RECIPES.register("armor_upgrade", () -> RecipeType.simple((ResourceLocation)Sauce.prefix("armor_upgrade")));
        ELEMENTAL_ARMOR_UP_SERIALIZER = SERIALIZERS.register("armor_upgrade", ElementalArmorRecipe.Serializer::new);
        CHARM_CHARGING_TYPE = RECIPES.register("charm_charging", () -> RecipeType.simple((ResourceLocation)Sauce.prefix("charm_charging")));
        CHARM_CHARGING_SERIALIZER = SERIALIZERS.register("charm_charging", CharmChargingRecipe.Serializer::new);
        E_TOME_CASTER = DATA_COMPONENT_TYPES.register("school_tome_caster", () -> DataComponentType.builder().persistent(SchoolCasterTomeData.CODEC.codec()).networkSynchronized(SchoolCasterTomeData.STREAM_CODEC).build());
        CHARM_DATA = DATA_COMPONENT_TYPES.register("charm_data", () -> DataComponentType.builder().persistent(CharmData.CODEC).networkSynchronized(CharmData.STREAM_CODEC).build());
    }
}

