/*
 * Decompiled with CFR 0.152.
 */
package com.alexthw.sauce.api.item.components;

import com.alexthw.sauce.registry.ModRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;

public record CharmData(int charges) {
    public static Codec<CharmData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("charges", (Object)0).forGetter(CharmData::charges)).apply((Applicative)instance, CharmData::new));
    public static StreamCodec<RegistryFriendlyByteBuf, CharmData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, CharmData::charges, CharmData::new);

    public CharmData use(int charges) {
        return this.set(this.charges - charges);
    }

    public CharmData set(int charges) {
        return new CharmData(Math.max(charges, 0));
    }

    public CharmData write(ItemStack stack) {
        return (CharmData)stack.set(ModRegistry.CHARM_DATA, (Object)this);
    }

    public static CharmData getOrDefault(ItemStack stack) {
        return CharmData.getOrDefault(stack, 0);
    }

    public static CharmData getOrDefault(ItemStack stack, int charges) {
        return (CharmData)stack.getOrDefault(ModRegistry.CHARM_DATA, (Object)new CharmData(charges));
    }
}

