/*
 * Decompiled with CFR 0.152.
 */
package com.alexthw.sauce.mixin;

import com.alexthw.sauce.util.GlyphEffectUtil;
import com.hollingsworth.arsnouveau.api.spell.IFilter;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.common.entity.EntityOrbitProjectile;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityOrbitProjectile.class})
public abstract class EntityOrbitMixin
extends EntityProjectileSpell {
    @Unique
    List<Predicate<LivingEntity>> sauce$ignore;

    @Inject(method={"<init>*"}, at={@At(value="TAIL")})
    public void constructor(Level world, SpellResolver resolver, Entity tracking, CallbackInfo ci) {
        Set<IFilter> filters = GlyphEffectUtil.getFilters(resolver.spell.unsafeList(), 0);
        ArrayList<Predicate<LivingEntity>> ignore = new ArrayList<Predicate<LivingEntity>>();
        if (!filters.isEmpty()) {
            ignore.add(entity -> GlyphEffectUtil.checkIgnoreFilters((Entity)entity, filters));
            this.sauce$setIgnored(ignore);
        }
    }

    public EntityOrbitMixin(EntityType<? extends EntityProjectileSpell> entityType, Level world) {
        super(entityType, world);
    }

    @Unique
    public void sauce$setIgnored(List<Predicate<LivingEntity>> ignore) {
        this.sauce$ignore = ignore;
    }

    @Unique
    public List<Predicate<LivingEntity>> sauce$getIgnored() {
        return this.sauce$ignore;
    }

    protected boolean canHitEntity(Entity entity) {
        boolean b = super.canHitEntity(entity);
        if (entity instanceof LivingEntity) {
            b &= this.sauce$shouldTarget((LivingEntity)entity);
        }
        return b;
    }

    @Unique
    private boolean sauce$shouldTarget(LivingEntity e) {
        if (this.sauce$ignore == null) {
            return false;
        }
        for (Predicate<LivingEntity> p : this.sauce$getIgnored()) {
            if (!p.test(e)) continue;
            return false;
        }
        return true;
    }
}

