/*
 * Decompiled with CFR 0.152.
 */
package com.alexthw.sauce.common.block;

import com.alexthw.sauce.api.item.ISchoolFocus;
import com.alexthw.sauce.common.block.FocusEnhancedSpellTurretTile;
import com.hollingsworth.arsnouveau.api.spell.EntitySpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.common.block.BasicSpellTurret;
import com.hollingsworth.arsnouveau.common.block.tile.RotatingTurretTile;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FocusEnhancedSpellTurret
extends BasicSpellTurret {
    public final SpellSchool school;

    public FocusEnhancedSpellTurret(BlockBehaviour.Properties properties, SpellSchool school) {
        super(properties.noOcclusion().forceSolidOn());
        this.school = school;
    }

    public void setPlacedBy(Level world, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack stack) {
        Direction orientation = placer == null ? Direction.WEST : Direction.orderedByNearest((Entity)placer)[0].getOpposite();
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (!(blockEntity instanceof RotatingTurretTile)) {
            return;
        }
        RotatingTurretTile turretTile = (RotatingTurretTile)blockEntity;
        switch (orientation) {
            case DOWN: {
                turretTile.neededRotationY = -90.0f;
                break;
            }
            case UP: {
                turretTile.neededRotationY = 90.0f;
                break;
            }
            case NORTH: {
                turretTile.neededRotationX = 270.0f;
                break;
            }
            case SOUTH: {
                turretTile.neededRotationX = 90.0f;
                break;
            }
            case WEST: {
                break;
            }
            case EAST: {
                turretTile.neededRotationX = 180.0f;
            }
        }
    }

    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new FocusEnhancedSpellTurretTile(pos, state).setSchool(this.school);
    }

    static class FocusTurretSpellResolver
    extends EntitySpellResolver {
        SpellSchool school;

        public FocusTurretSpellResolver(SpellContext context, SpellSchool tile) {
            super(context);
            this.school = tile;
        }

        public boolean hasFocus(ItemStack stack) {
            return this.hasFocus(stack.getItem());
        }

        public boolean hasFocus(Item item) {
            if (item instanceof ISchoolFocus) {
                ISchoolFocus focus = (ISchoolFocus)item;
                return this.school == focus.getSchool();
            }
            if (item == ItemsRegistry.SHAPERS_FOCUS.get()) {
                return this.school == SpellSchools.MANIPULATION;
            }
            return super.hasFocus(item);
        }

        public SpellResolver getNewResolver(SpellContext context) {
            return new FocusTurretSpellResolver(context, this.school);
        }
    }
}

