/*
 * Decompiled with CFR 0.152.
 */
package com.alexthw.sauce.common.recipe.jei;

import com.alexthw.sauce.common.recipe.CharmChargingRecipe;
import com.alexthw.sauce.common.recipe.jei.JeiSaucePlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class CharmChargingRecipeCategory
implements IRecipeCategory<CharmChargingRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"sauce", (String)"charm_charging");
    private final IDrawable background;
    private final IDrawable icon;
    private final Component title;

    public CharmChargingRecipeCategory(IGuiHelper helper) {
        this.background = helper.createBlankDrawable(120, 60);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Items.ENCHANTED_BOOK));
        this.title = Component.translatable((String)"jei.sauce.charm_charging");
    }

    @NotNull
    public RecipeType<CharmChargingRecipe> getRecipeType() {
        return JeiSaucePlugin.CHARM_CHARGING_RECIPE_TYPE;
    }

    @NotNull
    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CharmChargingRecipe recipe, @NotNull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 20, 20).addItemStack(new ItemStack((ItemLike)recipe.input()));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 80, 20).addItemStack(new ItemStack((ItemLike)recipe.input()));
        builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStack(new ItemStack((ItemLike)recipe.input()));
    }
}

