/*
 * Decompiled with CFR 0.152.
 */
package com.alexthw.sauce.event;

import com.alexthw.sauce.Sauce;
import com.alexthw.sauce.registry.ModRegistry;
import com.alexthw.sauce.registry.SauceTags;
import com.hollingsworth.arsnouveau.api.event.SpellCostCalcEvent;
import com.hollingsworth.arsnouveau.api.event.SpellDamageEvent;
import com.hollingsworth.arsnouveau.api.event.SpellModifierEvent;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.LivingCaster;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.util.FakePlayer;

public class AttributeEventHandler {
    public static final Map<SpellSchool, Holder<Attribute>> schoolToPowerAttribute = new ConcurrentHashMap<SpellSchool, Holder<Attribute>>();
    public static final Map<SpellSchool, Holder<Attribute>> schoolToDefenseAttribute = new ConcurrentHashMap<SpellSchool, Holder<Attribute>>();

    public static void linkSchoolToAttribute(SpellSchool school, Holder<Attribute> powerAttribute, Holder<Attribute> defenseAttribute) {
        if (powerAttribute != null) {
            schoolToPowerAttribute.put(school, powerAttribute);
        }
        if (defenseAttribute != null) {
            schoolToDefenseAttribute.put(school, defenseAttribute);
        }
    }

    @SubscribeEvent
    public static void discountSpell(SpellCostCalcEvent event) {
        IWrappedCaster iWrappedCaster = event.context.getCaster();
        if (iWrappedCaster instanceof LivingCaster) {
            AttributeInstance perk;
            Player player;
            LivingCaster caster = (LivingCaster)iWrappedCaster;
            LivingEntity livingEntity = caster.livingEntity;
            if (livingEntity instanceof Player && !((player = (Player)livingEntity) instanceof FakePlayer) && (perk = player.getAttribute(ModRegistry.MANA_DISCOUNT)) != null) {
                event.currentCost -= (int)perk.getValue();
            }
        }
    }

    @SubscribeEvent
    public static void critChance(SpellDamageEvent.Pre pre) {
        Player player;
        if (!Sauce.ENABLE_SPELL_CRIT) {
            return;
        }
        LivingEntity livingEntity = pre.caster;
        if (livingEntity instanceof Player && !((player = (Player)livingEntity) instanceof FakePlayer)) {
            double chance;
            AttributeInstance critChance = player.getAttribute(ModRegistry.SPELL_CRIT);
            AttributeInstance critDamage = player.getAttribute(ModRegistry.SPELL_CRIT_DAMAGE);
            if (critChance != null && critDamage != null && (chance = critChance.getValue()) > 0.0 && pre.caster.getRandom().nextDouble() < chance / 100.0) {
                pre.damage *= (float)(1.0 + critDamage.getValue() / 100.0);
            }
        }
    }

    @SubscribeEvent
    public static void elementalDefense(SpellDamageEvent.Pre pre) {
        Entity entity = pre.target;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            HashSet<SpellSchool> schools = new HashSet<SpellSchool>();
            for (Map.Entry<SpellSchool, Holder<Attribute>> entry : schoolToDefenseAttribute.entrySet()) {
                SpellSchool school = entry.getKey();
                List tags = SauceTags.SCHOOL_TO_DAMAGE_TYPES.getOrDefault(school, List.of());
                if (!tags.stream().anyMatch(tag -> pre.damageSource.is(tag))) continue;
                schools.add(school);
                if (school == SpellSchools.ELEMENTAL) continue;
                schools.addAll(school.getSubSchools());
            }
            for (SpellSchool school : schools) {
                double resistance;
                AttributeInstance attrInstance;
                Holder<Attribute> attribute = schoolToDefenseAttribute.get(school);
                if (attribute == null || (attrInstance = player.getAttribute(attribute)) == null || (resistance = attrInstance.getValue()) == 0.0) continue;
                pre.damage *= (float)Math.pow(2.0, -resistance / 100.0);
            }
        }
    }

    @SubscribeEvent
    public static void empowerBySchool(SpellModifierEvent event) {
        if (event.spellPart == null) {
            return;
        }
        List schools = event.spellPart.spellSchools;
        if (schools.isEmpty()) {
            return;
        }
        for (SpellSchool school : schools) {
            AttributeEventHandler.empowerSchool(event, school);
            if (school == SpellSchools.ELEMENTAL) continue;
            for (SpellSchool subSchool : school.getSubSchools()) {
                AttributeEventHandler.empowerSchool(event, subSchool);
            }
        }
    }

    private static void empowerSchool(SpellModifierEvent event, SpellSchool school) {
        Holder<Attribute> attribute = schoolToPowerAttribute.get(school);
        if (attribute != null && event.caster != null) {
            double power;
            double d = power = event.caster.getAttributes().hasAttribute(attribute) ? event.caster.getAttributeValue(attribute) : 0.0;
            if (power != 0.0) {
                event.builder.addDamageModifier(power);
            }
        }
    }

    static {
        AttributeEventHandler.linkSchoolToAttribute(SpellSchools.MANIPULATION, ModRegistry.MANIPULATION_POWER, ModRegistry.MANIPULATION_RESISTANCE);
        AttributeEventHandler.linkSchoolToAttribute(SpellSchools.CONJURATION, ModRegistry.SUMMON_POWER, ModRegistry.CONJURATION_RESISTANCE);
        AttributeEventHandler.linkSchoolToAttribute(SpellSchools.ABJURATION, ModRegistry.ABJURATION_POWER, ModRegistry.ABJURATION_RESISTANCE);
        AttributeEventHandler.linkSchoolToAttribute(SpellSchools.NECROMANCY, ModRegistry.NECROMANCY_POWER, ModRegistry.NECROMANCY_RESISTANCE);
        AttributeEventHandler.linkSchoolToAttribute(SpellSchools.ELEMENTAL_AIR, ModRegistry.AIR_POWER, ModRegistry.AIR_RESISTANCE);
        AttributeEventHandler.linkSchoolToAttribute(SpellSchools.ELEMENTAL_WATER, ModRegistry.WATER_POWER, ModRegistry.WATER_RESISTANCE);
        AttributeEventHandler.linkSchoolToAttribute(SpellSchools.ELEMENTAL_EARTH, ModRegistry.EARTH_POWER, ModRegistry.EARTH_RESISTANCE);
        AttributeEventHandler.linkSchoolToAttribute(SpellSchools.ELEMENTAL_FIRE, ModRegistry.FIRE_POWER, ModRegistry.FIRE_RESISTANCE);
        AttributeEventHandler.linkSchoolToAttribute(SpellSchools.ELEMENTAL, ModRegistry.ELEMENTAL_POWER, ModRegistry.ELEMENTAL_RESISTANCE);
    }
}

