/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.registries;

import alexthw.eidolon_repraised.Eidolon;
import alexthw.eidolon_repraised.api.ritual.IncenseRitual;
import alexthw.eidolon_repraised.common.incense.BloodlustIncense;
import alexthw.eidolon_repraised.common.incense.DeathBaneIncense;
import alexthw.eidolon_repraised.common.incense.FrailIncense;
import alexthw.eidolon_repraised.common.incense.FrostbindIncense;
import alexthw.eidolon_repraised.common.incense.GloomIncense;
import alexthw.eidolon_repraised.common.incense.PrayerIncense;
import alexthw.eidolon_repraised.common.incense.PurityIncense;
import alexthw.eidolon_repraised.common.incense.QuickenIncense;
import alexthw.eidolon_repraised.common.incense.RestorationIncense;
import alexthw.eidolon_repraised.common.incense.SoulHarvestIncense;
import alexthw.eidolon_repraised.common.incense.TetherIncense;
import alexthw.eidolon_repraised.common.incense.ToughIncense;
import alexthw.eidolon_repraised.common.incense.UndeathIncense;
import alexthw.eidolon_repraised.registries.Registry;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class IncenseRegistry {
    static final Map<ResourceLocation, Supplier<IncenseRitual>> incenses = new HashMap<ResourceLocation, Supplier<IncenseRitual>>();
    static final Map<Item, ResourceLocation> itemToIncense = new HashMap<Item, ResourceLocation>();
    public static final ResourceLocation PRAYER_INCENSE = Eidolon.prefix("prayer_incense");
    public static final ResourceLocation RESTORATION_INCENSE = Eidolon.prefix("restoration_incense");
    public static final ResourceLocation GLOOM_INCENSE = Eidolon.prefix("gloom_incense");
    public static final ResourceLocation DEATH_BANE_INCENSE = Eidolon.prefix("death_bane_incense");
    public static final ResourceLocation TOUGH_INCENSE = Eidolon.prefix("tough_incense");
    public static final ResourceLocation FRAIL_INCENSE = Eidolon.prefix("frail_incense");
    public static final ResourceLocation FROSTBIND_INCENSE = Eidolon.prefix("frostbind_incense");
    public static final ResourceLocation TETHER_INCENSE = Eidolon.prefix("tether_incense");
    public static final ResourceLocation PURITY_INCENSE = Eidolon.prefix("purity_incense");
    public static final ResourceLocation QUICKEN_INCENSE = Eidolon.prefix("quicken_incense");
    public static final ResourceLocation BLOODLUST_INCENSE = Eidolon.prefix("bloodlust_incense");
    public static final ResourceLocation SOUL_HARVEST_INCENSE = Eidolon.prefix("soul_harvest_incense");
    public static final ResourceLocation WARDING_INCENSE = Eidolon.prefix("warding_incense");
    public static final ResourceLocation UNDEATH_INCENSE = Eidolon.prefix("undeath_incense");
    public static final ResourceLocation GROWTH_INCENSE = Eidolon.prefix("growth_incense");

    public static void register(Item incense, ResourceLocation name, Supplier<IncenseRitual> incenseRitualSupplier) {
        assert (name != null);
        itemToIncense.put(incense, name);
        incenses.put(name, incenseRitualSupplier);
    }

    public static IncenseRitual getIncenseRitual(Item item) {
        if (!itemToIncense.containsKey(item)) {
            return null;
        }
        return IncenseRegistry.getIncenseRitual(itemToIncense.get(item));
    }

    public static IncenseRitual getIncenseRitual(ResourceLocation name) {
        return incenses.get(name).get();
    }

    public static void init() {
        IncenseRegistry.register((Item)Registry.OFFERING_INCENSE.get(), PRAYER_INCENSE, () -> new PrayerIncense(PRAYER_INCENSE));
        IncenseRegistry.register((Item)Registry.GLOOM_INCENSE.get(), GLOOM_INCENSE, () -> new GloomIncense(GLOOM_INCENSE));
        IncenseRegistry.register((Item)Registry.RESTORATION_INCENSE.get(), RESTORATION_INCENSE, () -> new RestorationIncense(RESTORATION_INCENSE));
        IncenseRegistry.register((Item)Registry.DEATH_BANE_INCENSE.get(), DEATH_BANE_INCENSE, () -> new DeathBaneIncense(DEATH_BANE_INCENSE));
        IncenseRegistry.register((Item)Registry.UNDEATH_INCENSE.get(), UNDEATH_INCENSE, () -> new UndeathIncense(UNDEATH_INCENSE));
        IncenseRegistry.register((Item)Registry.FROSTBIND_INCENSE.get(), FROSTBIND_INCENSE, () -> new FrostbindIncense(FROSTBIND_INCENSE));
        IncenseRegistry.register((Item)Registry.TETHER_INCENSE.get(), TETHER_INCENSE, () -> new TetherIncense(TETHER_INCENSE));
        IncenseRegistry.register((Item)Registry.PURITY_INCENSE.get(), PURITY_INCENSE, () -> new PurityIncense(PURITY_INCENSE));
        IncenseRegistry.register((Item)Registry.QUICKEN_INCENSE.get(), QUICKEN_INCENSE, () -> new QuickenIncense(QUICKEN_INCENSE));
        IncenseRegistry.register((Item)Registry.BLOODLUST_INCENSE.get(), BLOODLUST_INCENSE, () -> new BloodlustIncense(BLOODLUST_INCENSE));
        IncenseRegistry.register((Item)Registry.SOUL_HARVEST_INCENSE.get(), SOUL_HARVEST_INCENSE, () -> new SoulHarvestIncense(SOUL_HARVEST_INCENSE));
        IncenseRegistry.register((Item)Registry.FRAIL_INCENSE.get(), FRAIL_INCENSE, () -> new FrailIncense(FRAIL_INCENSE));
        IncenseRegistry.register((Item)Registry.TOUGH_INCENSE.get(), TOUGH_INCENSE, () -> new ToughIncense(TOUGH_INCENSE));
    }
}

