/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.recipe;

import alexthw.eidolon_repraised.common.tile.CrucibleTileEntity;
import alexthw.eidolon_repraised.recipe.CrucibleRecipe;
import alexthw.eidolon_repraised.registries.EidolonRecipes;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class CrucibleHelper {
    public static CrucibleRecipe find(Level level, List<CrucibleTileEntity.CrucibleStep> steps) {
        List recipeHolders = level.getRecipeManager().getAllRecipesFor((RecipeType)EidolonRecipes.CRUCIBLE_TYPE.get());
        for (RecipeHolder holder : recipeHolders) {
            CrucibleRecipe recipe = (CrucibleRecipe)holder.value();
            if (steps.size() != recipe.getSteps().size() || !CrucibleHelper.doStepsMatch(steps, recipe.getSteps())) continue;
            return recipe;
        }
        return null;
    }

    public static boolean doStepsHaveSomeResult(Level level, List<CrucibleTileEntity.CrucibleStep> steps) {
        List recipes = level.getRecipeManager().getAllRecipesFor((RecipeType)EidolonRecipes.CRUCIBLE_TYPE.get());
        for (RecipeHolder holder : recipes) {
            CrucibleRecipe recipe = (CrucibleRecipe)holder.value();
            if (steps.size() > recipe.getSteps().size() || !CrucibleHelper.doStepsMatch(steps, recipe.getSteps())) continue;
            return true;
        }
        return false;
    }

    private static boolean doStepsMatch(List<CrucibleTileEntity.CrucibleStep> steps, List<CrucibleRecipe.Step> otherSteps) {
        for (int i = 0; i < steps.size(); ++i) {
            CrucibleTileEntity.CrucibleStep step = steps.get(i);
            CrucibleRecipe.Step otherStep = otherSteps.get(i);
            if (step.getStirs() != otherStep.stirs()) {
                return false;
            }
            if (step.getContents().size() != otherStep.matches().size()) {
                return false;
            }
            if (CrucibleHelper.doContentsMatch(step, otherStep)) continue;
            return false;
        }
        return true;
    }

    private static boolean doContentsMatch(CrucibleTileEntity.CrucibleStep crucibleStep, CrucibleRecipe.Step recipeToMatch) {
        List<Ingredient> ingredients = recipeToMatch.matches();
        boolean[] used = new boolean[ingredients.size()];
        for (ItemStack input : crucibleStep.getContents()) {
            boolean matched = false;
            for (int i = 0; i < ingredients.size(); ++i) {
                if (used[i] || !ingredients.get(i).test(input)) continue;
                used[i] = true;
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        return true;
    }
}

