/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.tile;

import alexthw.eidolon_repraised.api.ritual.IRitualItemFocus;
import alexthw.eidolon_repraised.common.tile.ContainerTileBase;
import alexthw.eidolon_repraised.registries.Registry;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class NecroticFocusTileEntity
extends ContainerTileBase
implements IRitualItemFocus {
    public NecroticFocusTileEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)Registry.NECROTIC_FOCUS_TILE_ENTITY.get(), pos, state);
    }

    public NecroticFocusTileEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    @Override
    public void onDestroyed(BlockState state, BlockPos pos) {
        if (!this.stack.isEmpty()) {
            Containers.dropItemStack((Level)this.level, (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.5), (double)((double)pos.getZ() + 0.5), (ItemStack)this.stack);
        }
    }

    @Override
    public ItemInteractionResult onActivated(BlockState state, BlockPos pos, Player player, InteractionHand hand) {
        if (hand == InteractionHand.MAIN_HAND) {
            if (player.getItemInHand(hand).isEmpty() && !this.stack.isEmpty()) {
                player.addItem(this.stack);
                this.stack = ItemStack.EMPTY;
                if (!this.level.isClientSide) {
                    this.sync();
                }
                return ItemInteractionResult.SUCCESS;
            }
            if (!player.getItemInHand(hand).isEmpty() && this.stack.isEmpty()) {
                this.stack = player.getItemInHand(hand).copy();
                this.stack.setCount(1);
                player.getItemInHand(hand).shrink(1);
                if (player.getItemInHand(hand).isEmpty()) {
                    player.setItemInHand(hand, ItemStack.EMPTY);
                }
                if (!this.level.isClientSide) {
                    this.sync();
                }
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    public ItemStack provide() {
        return this.stack.copy();
    }

    @Override
    public void take() {
        this.stack = ItemStack.EMPTY;
        if (!this.level.isClientSide) {
            this.sync();
        }
    }

    @Override
    public void replace(ItemStack stack) {
        this.stack = stack;
        if (!this.level.isClientSide) {
            this.sync();
        }
    }
}

