/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.item.curio;

import alexthw.eidolon_repraised.common.item.curio.EidolonCurio;
import alexthw.eidolon_repraised.registries.Registry;
import com.google.common.collect.Multimap;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

public class ResoluteBeltItem
extends EidolonCurio {
    final UUID ATTR_ID = new UUID(3701779382882225399L, 5035874982077300549L);
    static final Random random = new Random();

    public ResoluteBeltItem(Item.Properties properties) {
        super(properties);
        NeoForge.EVENT_BUS.addListener(ResoluteBeltItem::onHurt);
    }

    @SubscribeEvent
    public static void onHurt(LivingDamageEvent.Post event) {
        Entity entity = event.getSource().getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            if (CuriosApi.getCuriosInventory((LivingEntity)event.getEntity()).flatMap(i -> i.findFirstCurio((Item)Registry.RESOLUTE_BELT.get())).isPresent()) {
                Vec3 diff = event.getEntity().position().subtract(entity2.position()).multiply(1.0, 0.0, 1.0).normalize();
                entity2.knockback((double)0.8f, diff.x, diff.z);
                if (!entity2.level().isClientSide) {
                    entity2.level().playSound(null, entity2.blockPosition(), SoundEvents.IRON_GOLEM_HURT, SoundSource.PLAYERS, 1.0f, 1.9f + 0.2f * random.nextFloat());
                }
            }
        }
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation uuid, ItemStack stack) {
        Multimap map = super.getAttributeModifiers(slotContext, uuid, stack);
        map.put((Object)Attributes.KNOCKBACK_RESISTANCE, (Object)new AttributeModifier(uuid, 1.0, AttributeModifier.Operation.ADD_VALUE));
        return map;
    }
}

