/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.api.altar;

import alexthw.eidolon_repraised.api.altar.AltarInfo;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.resources.ResourceLocation;

public record AltarEntry(ResourceLocation key, double capacity, double power) {
    public static final Codec<AltarEntry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("key").forGetter(AltarEntry::key), (App)Codec.DOUBLE.optionalFieldOf("capacity", (Object)0.0).forGetter(AltarEntry::capacity), (App)Codec.DOUBLE.optionalFieldOf("power", (Object)0.0).forGetter(AltarEntry::power)).apply((Applicative)instance, AltarEntry::new));

    public AltarEntry(ResourceLocation key, double power) {
        this(key, 0.0, 0.0);
    }

    public void apply(AltarInfo info) {
        info.attributes.computeIfAbsent(this.key, k -> new AltarInfo.AltarAttributes());
        if (this.capacity > 0.0) {
            info.increaseCapacity(this.key, this.capacity);
        }
        if (this.power > 0.0) {
            info.increasePower(this.key, this.power);
        }
    }
}

