package alexthw.eidolon_repraised.registries;

import alexthw.eidolon_repraised.Eidolon;
import alexthw.eidolon_repraised.api.spells.Rune;
import alexthw.eidolon_repraised.api.spells.SignSequence;
import net.minecraft.resources.ResourceLocation;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class Runes {
    static final Map<ResourceLocation, Rune> runes = new HashMap<>();

    public static void register(Rune rune) {
        runes.put(rune.getRegistryName(), rune);
    }

    public static Rune find(ResourceLocation rl) {
        return runes.getOrDefault(rl, null);
    }

    public static Collection<Rune> getRunes() {
        return runes.values();
    }

    public static void init() {
        register(new Rune(ResourceLocation.fromNamespaceAndPath(Eidolon.MODID,"sin" )) {
            @Override
            public RuneResult doEffect(SignSequence seq) {
                seq.addRight(Signs.WICKED_SIGN);
                return RuneResult.PASS;
            }
        });
        register(new Rune(ResourceLocation.fromNamespaceAndPath(Eidolon.MODID,"crimson_rose" )) {
            @Override
            public RuneResult doEffect(SignSequence seq) {
                if (seq.removeRightmostN(Signs.WICKED_SIGN, 2)) {
                    seq.addRight(Signs.BLOOD_SIGN);
                    return RuneResult.PASS;
                }
                return RuneResult.FAIL;
            }
        });
        register(new Rune(ResourceLocation.fromNamespaceAndPath(Eidolon.MODID,"wing" )) {
            @Override
            public RuneResult doEffect(SignSequence seq) {
                return RuneResult.PASS;
            }
        });
        register(new Rune(ResourceLocation.fromNamespaceAndPath(Eidolon.MODID,"purity" )) {
            @Override
            public RuneResult doEffect(SignSequence seq) {
                return RuneResult.PASS;
            }
        });
    }
}
