package alexthw.eidolon_repraised.recipe;

import alexthw.eidolon_repraised.common.tile.CrucibleTileEntity.CrucibleStep;
import alexthw.eidolon_repraised.registries.EidolonRecipes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;

import java.util.List;

public class CrucibleHelper {

    public static CrucibleRecipe find(Level level, List<CrucibleStep> steps) {
        List<RecipeHolder<CrucibleRecipe>> recipeHolders = level.getRecipeManager().getAllRecipesFor(EidolonRecipes.CRUCIBLE_TYPE.get());
        for (RecipeHolder<CrucibleRecipe> holder : recipeHolders) {
            CrucibleRecipe recipe = holder.value();
            // we have more steps currently than the testFor recipe, there's no way it matches.
            if (steps.size() != recipe.getSteps().size()) continue;
            if (doStepsMatch(steps, recipe.getSteps())) return recipe;
        }

        return null;
    }

    public static boolean doStepsHaveSomeResult(Level level, List<CrucibleStep> steps) {
        List<RecipeHolder<CrucibleRecipe>> recipes = level.getRecipeManager().getAllRecipesFor(EidolonRecipes.CRUCIBLE_TYPE.get());
        for (RecipeHolder<CrucibleRecipe> holder : recipes) {
            CrucibleRecipe recipe = holder.value();
            // we have more steps currently than the testFor recipe, there's no way it matches.
            if (steps.size() > recipe.getSteps().size()) continue;
            if (doStepsMatch(steps, recipe.getSteps())) return true;
        }

        return false;
    }

    private static boolean doStepsMatch(List<CrucibleStep> steps, List<CrucibleRecipe.Step> otherSteps) {
        for (int i = 0; i < steps.size(); i++) {
            CrucibleStep step = steps.get(i);
            CrucibleRecipe.Step otherStep = otherSteps.get(i);
            if (step.getStirs() != otherStep.stirs()) return false;
            if (step.getContents().size() != otherStep.matches().size()) return false;
            if (!doContentsMatch(step, otherStep)) return false;
        }

        return true;
    }

    private static boolean doContentsMatch(CrucibleStep crucibleStep, CrucibleRecipe.Step recipeToMatch) {
        List<Ingredient> ingredients = recipeToMatch.matches();
        boolean[] used = new boolean[ingredients.size()];

        for (ItemStack input : crucibleStep.getContents()) {
            boolean matched = false;
            for (int i = 0; i < ingredients.size(); i++) {
                if (!used[i] && ingredients.get(i).test(input)) {
                    used[i] = true;
                    matched = true;
                    break;
                }
            }
            if (!matched) return false;
        }

        return true;
    }

//    public static void init() {
//        register(new CrucibleRecipe(new ItemStack(Registry.ARCANE_GOLD_INGOT.get(), 2)).setRegistryName(Eidolon.MODID, "arcane_gold")
//            .addStep(Tags.Items.DUSTS_REDSTONE, Tags.Items.DUSTS_REDSTONE, Registry.SOUL_SHARD.get())
//            .addStep(Tags.Items.INGOTS_GOLD, Tags.Items.INGOTS_GOLD));
//        register(new CrucibleRecipe(new ItemStack(Registry.LESSER_SOUL_GEM.get())).setRegistryName(Eidolon.MODID, "lesser_soul_gem")
//            .addStep(Tags.Items.DUSTS_REDSTONE, Tags.Items.DUSTS_REDSTONE, Tags.Items.GEMS_LAPIS, Tags.Items.GEMS_LAPIS)
//            .addStirringStep(2, Registry.SOUL_SHARD.get(), Registry.SOUL_SHARD.get(), Registry.SOUL_SHARD.get(), Registry.SOUL_SHARD.get())
//            .addStep(Tags.Items.GEMS_QUARTZ));
//        register(new CrucibleRecipe(new ItemStack(Registry.SHADOW_GEM.get())).setRegistryName(Eidolon.MODID, "shadow_gem")
//            .addStep(Items.COAL)
//            .addStirringStep(1, Items.GHAST_TEAR, Registry.DEATH_ESSENCE.get())
//            .addStirringStep(1, Registry.SOUL_SHARD.get(), Registry.SOUL_SHARD.get(), Registry.DEATH_ESSENCE.get())
//            .addStep(Tags.Items.GEMS_DIAMOND));
//        register(new CrucibleRecipe(new ItemStack(Registry.SULFUR.get(), 2)).setRegistryName(Eidolon.MODID, "sulfur")
//            .addStep(Items.COAL, Registry.ENCHANTED_ASH.get()));
//        register(new CrucibleRecipe(new ItemStack(Registry.ENDER_CALX.get(), 2)).setRegistryName(Eidolon.MODID, "ender_calx")
//            .addStep(Tags.Items.ENDER_PEARLS, Registry.ENCHANTED_ASH.get()));
//        register(new CrucibleRecipe(new ItemStack(Items.LEATHER, 1)).setRegistryName(Eidolon.MODID, "leather_from_flesh")
//            .addStep(Registry.ENCHANTED_ASH.get(), Registry.ENCHANTED_ASH.get())
//            .addStirringStep(2, Items.ROTTEN_FLESH));
//        register(new CrucibleRecipe(new ItemStack(Items.ROTTEN_FLESH, 1)).setRegistryName(Eidolon.MODID, "rotten_beef")
//            .addStep(Items.BEEF, Tags.Items.MUSHROOMS));
//        register(new CrucibleRecipe(new ItemStack(Items.ROTTEN_FLESH, 1)).setRegistryName(Eidolon.MODID, "rotten_pork")
//            .addStep(Items.PORKCHOP, Tags.Items.MUSHROOMS));
//        register(new CrucibleRecipe(new ItemStack(Items.ROTTEN_FLESH, 1)).setRegistryName(Eidolon.MODID, "rotten_mutton")
//            .addStep(Items.MUTTON, Tags.Items.MUSHROOMS));
//        register(new CrucibleRecipe(new ItemStack(Items.ROTTEN_FLESH, 1)).setRegistryName(Eidolon.MODID, "rotten_chicken")
//            .addStep(Items.CHICKEN, Tags.Items.MUSHROOMS));
//        register(new CrucibleRecipe(new ItemStack(Items.ROTTEN_FLESH, 1)).setRegistryName(Eidolon.MODID, "rotten_rabbit")
//            .addStep(Items.RABBIT, Tags.Items.MUSHROOMS));
//        register(new CrucibleRecipe(new ItemStack(Items.GUNPOWDER, 4)).setRegistryName(Eidolon.MODID, "gunpowder")
//            .addStep(Registry.SULFUR.get(), Items.BONE_MEAL)
//            .addStirringStep(1, Items.CHARCOAL));
//        register(new CrucibleRecipe(new ItemStack(Items.GOLDEN_APPLE, 1)).setRegistryName(Eidolon.MODID, "gilded_apple")
//            .addStep(Tags.Items.INGOTS_GOLD, Tags.Items.INGOTS_GOLD)
//            .addStirringStep(2, Registry.ENCHANTED_ASH.get())
//            .addStep(Items.APPLE));
//        register(new CrucibleRecipe(new ItemStack(Items.GOLDEN_CARROT, 1)).setRegistryName(Eidolon.MODID, "gilded_carrot")
//            .addStep(Tags.Items.NUGGETS_GOLD, Tags.Items.NUGGETS_GOLD)
//            .addStirringStep(2, Registry.ENCHANTED_ASH.get())
//            .addStep(Items.CARROT));
//        register(new CrucibleRecipe(new ItemStack(Items.GLISTERING_MELON_SLICE, 1)).setRegistryName(Eidolon.MODID, "gilded_melon")
//            .addStep(Tags.Items.NUGGETS_GOLD, Tags.Items.NUGGETS_GOLD)
//            .addStirringStep(2, Registry.ENCHANTED_ASH.get())
//            .addStep(Items.MELON_SLICE));
//        register(new CrucibleRecipe(new ItemStack(Registry.DEATH_ESSENCE.get(), 4)).setRegistryName(Eidolon.MODID, "death_essence")
//            .addStep(Registry.ZOMBIE_HEART.get(), Items.ROTTEN_FLESH)
//            .addStirringStep(2, Items.BONE_MEAL, Items.BONE_MEAL)
//            .addStep(Items.CHARCOAL));
//        register(new CrucibleRecipe(new ItemStack(Registry.CRIMSON_ESSENCE.get(), 4)).setRegistryName(Eidolon.MODID, "crimson_essence_fungus")
//            .addStep(Items.CRIMSON_FUNGUS, Items.NETHER_WART)
//            .addStirringStep(1, Registry.SULFUR.get()));
//        register(new CrucibleRecipe(new ItemStack(Registry.CRIMSON_ESSENCE.get(), 2)).setRegistryName(Eidolon.MODID, "crimson_essence_roots")
//            .addStep(Items.CRIMSON_ROOTS, Items.NETHER_WART)
//            .addStirringStep(1, Registry.SULFUR.get()));
//        register(new CrucibleRecipe(new ItemStack(Registry.CRIMSON_ESSENCE.get(), 2)).setRegistryName(Eidolon.MODID, "crimson_essence_vines")
//            .addStep(Items.WEEPING_VINES, Items.NETHER_WART)
//            .addStirringStep(1, Registry.SULFUR.get()));
//        register(new CrucibleRecipe(new ItemStack(Registry.FUNGUS_SPROUTS.get(), 2)).setRegistryName(Eidolon.MODID, "fungus_sprouts")
//            .addStep(Tags.Items.MUSHROOMS)
//            .addStirringStep(2, Items.BONE_MEAL)
//            .addStep(Items.WHEAT_SEEDS));
//        register(new CrucibleRecipe(new ItemStack(Registry.WARPED_SPROUTS.get(), 2)).setRegistryName(Eidolon.MODID, "warped_sprouts")
//            .addStep(Blocks.WARPED_FUNGUS)
//            .addStirringStep(2, Registry.ENDER_CALX.get())
//            .addStep(Items.NETHER_WART));
//        register(new CrucibleRecipe(new ItemStack(Registry.POLISHED_PLANKS.getBlock(), 32)).setRegistryName(Eidolon.MODID, "polished_planks")
//            .addStep(ItemTags.PLANKS, ItemTags.PLANKS, ItemTags.PLANKS, ItemTags.PLANKS,
//                ItemTags.PLANKS, ItemTags.PLANKS, ItemTags.PLANKS, ItemTags.PLANKS,
//                ItemTags.PLANKS, ItemTags.PLANKS, ItemTags.PLANKS, ItemTags.PLANKS,
//                ItemTags.PLANKS, ItemTags.PLANKS, ItemTags.PLANKS, ItemTags.PLANKS,
//                ItemTags.PLANKS, ItemTags.PLANKS, ItemTags.PLANKS, ItemTags.PLANKS,
//                ItemTags.PLANKS, ItemTags.PLANKS, ItemTags.PLANKS, ItemTags.PLANKS,
//                ItemTags.PLANKS, ItemTags.PLANKS, ItemTags.PLANKS, ItemTags.PLANKS,
//                ItemTags.PLANKS, ItemTags.PLANKS, ItemTags.PLANKS, ItemTags.PLANKS)
//            .addStirringStep(1, Registry.SOUL_SHARD.get(), Registry.ENCHANTED_ASH.get()));
//    }

}
