package alexthw.eidolon_repraised.client.particle;

import alexthw.eidolon_repraised.api.spells.Rune;
import alexthw.eidolon_repraised.registries.EidolonParticles;
import alexthw.eidolon_repraised.registries.Runes;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class RuneParticleData implements ParticleOptions {
    final Rune rune;
    final float r1;
    final float g1;
    final float b1;
    final float r2;
    final float g2;
    final float b2;

    public static MapCodec<RuneParticleData> codecFor() {
        return RecordCodecBuilder.mapCodec(instance -> instance.group(
                Codec.STRING.fieldOf("rune").forGetter((d) -> d.rune.getRegistryName().toString()),
                Codec.FLOAT.fieldOf("r1").forGetter((d) -> d.r1),
                Codec.FLOAT.fieldOf("g1").forGetter((d) -> d.g1),
                Codec.FLOAT.fieldOf("b1").forGetter((d) -> d.b1),
                Codec.FLOAT.fieldOf("r2").forGetter((d) -> d.r2),
                Codec.FLOAT.fieldOf("g2").forGetter((d) -> d.g2),
                Codec.FLOAT.fieldOf("b2").forGetter((d) -> d.b2)
        ).apply(instance, (rune, r1, g1, b1, r2, g2, b2) -> new RuneParticleData(Runes.find(ResourceLocation.parse(rune)), r1, g1, b1, r2, g2, b2)));
    }

    public static StreamCodec<RegistryFriendlyByteBuf, RuneParticleData> streamCodecFor() {
        return StreamCodec.of(
                (buf, data) -> {
                    buf.writeResourceLocation(data.rune.getRegistryName());
                    buf.writeFloat(data.r1);
                    buf.writeFloat(data.g1);
                    buf.writeFloat(data.b1);
                    buf.writeFloat(data.r2);
                    buf.writeFloat(data.g2);
                    buf.writeFloat(data.b2);
                },
                buf -> {
                    ResourceLocation runeName = buf.readResourceLocation();
                    float r1 = buf.readFloat();
                    float g1 = buf.readFloat();
                    float b1 = buf.readFloat();
                    float r2 = buf.readFloat();
                    float g2 = buf.readFloat();
                    float b2 = buf.readFloat();
                    return new RuneParticleData(Runes.find(runeName), r1, g1, b1, r2, g2, b2);
                }
        );
    }


    public RuneParticleData(Rune rune, float r1, float g1, float b1, float r2, float g2, float b2) {
        this.rune = rune;
        this.r1 = r1;
        this.g1 = g1;
        this.b1 = b1;
        this.r2 = r2;
        this.g2 = g2;
        this.b2 = b2;
    }

    @Override
    public @NotNull ParticleType<?> getType() {
        return EidolonParticles.RUNE_PARTICLE.get();
    }

}
