/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.spell;

import alexthw.eidolon_repraised.api.altar.AltarInfo;
import alexthw.eidolon_repraised.api.capability.IMana;
import alexthw.eidolon_repraised.api.capability.IReputation;
import alexthw.eidolon_repraised.api.spells.Sign;
import alexthw.eidolon_repraised.common.deity.Deities;
import alexthw.eidolon_repraised.common.deity.DeityLocks;
import alexthw.eidolon_repraised.common.spell.PrayerSpell;
import alexthw.eidolon_repraised.common.tile.EffigyTileEntity;
import alexthw.eidolon_repraised.registries.AdvancementTriggers;
import alexthw.eidolon_repraised.registries.EidolonCapabilities;
import alexthw.eidolon_repraised.registries.Registry;
import alexthw.eidolon_repraised.registries.Signs;
import alexthw.eidolon_repraised.util.KnowledgeUtil;
import com.mojang.serialization.DynamicOps;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.event.EventHooks;

public class ZombifySpell
extends PrayerSpell {
    public ZombifySpell(ResourceLocation resourceLocation, int baseRep, double powerMult, Sign ... signs) {
        super(resourceLocation, Deities.DARK_DEITY, 20, baseRep, powerMult, signs);
    }

    @Override
    public boolean canCast(Level world, BlockPos pos, Player player) {
        EntityHitResult result;
        HitResult ray = ZombifySpell.rayTrace((Entity)player, player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE), 0.0f, true);
        boolean flag = ray instanceof EntityHitResult && (result = (EntityHitResult)ray).getEntity() instanceof Villager;
        EffigyTileEntity effigy = ZombifySpell.getEffigy(world, pos);
        if (effigy == null) {
            player.displayClientMessage((Component)Component.translatable((String)"eidolon_repraised.message.no_effigy"), true);
            return false;
        }
        AltarInfo info = AltarInfo.getAltarInfo(world, effigy.getBlockPos());
        if (info.getAltar() != Registry.STONE_ALTAR.get() || info.getIcon() != Registry.ELDER_EFFIGY.get()) {
            return false;
        }
        return flag && super.canCast(world, pos, player);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void cast(Level world, BlockPos pos, Player player) {
        EffigyTileEntity effigy = ZombifySpell.getEffigy(world, pos);
        if (effigy == null) {
            return;
        }
        HitResult ray = ZombifySpell.rayTrace((Entity)player, player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE), 0.0f, true);
        if (!(ray instanceof EntityHitResult)) return;
        EntityHitResult result = (EntityHitResult)ray;
        Entity entity = result.getEntity();
        if (!(entity instanceof Villager)) return;
        Villager villager = (Villager)entity;
        if (world instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)world;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                effigy.pray();
                AltarInfo info = AltarInfo.getAltarInfo(world, effigy.getBlockPos());
                IReputation rep = (IReputation)player.getCapability(EidolonCapabilities.REPUTATION_CAPABILITY);
                if (rep != null) {
                    rep.pray(this, world.getGameTime());
                    ((PlayerTrigger)AdvancementTriggers.ZOMBIFY.get()).trigger(serverPlayer);
                    KnowledgeUtil.grantResearchNoToast((Entity)player, DeityLocks.ZOMBIFY_VILLAGER);
                    rep.addReputation(this.deity.getId(), (double)this.getBaseRep() + this.getPowerMultiplier() * info.getPower());
                    ZombifySpell.updateMagic(info, player, world, rep.getReputation(this.deity.getId()));
                }
                this.zombify(villager, level);
                IMana.expendMana(player, this.getCost());
                return;
            }
        }
        this.playSuccessSound(world, player, effigy, Signs.DEATH_SIGN);
    }

    private void zombify(Villager villager, ServerLevel level) {
        ZombieVillager zombievillager = (ZombieVillager)villager.convertTo(EntityType.ZOMBIE_VILLAGER, false);
        if (zombievillager == null) {
            return;
        }
        zombievillager.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(zombievillager.blockPosition()), MobSpawnType.CONVERSION, (SpawnGroupData)new Zombie.ZombieGroupData(false, true));
        zombievillager.setVillagerData(villager.getVillagerData());
        zombievillager.setGossips((Tag)villager.getGossips().store((DynamicOps)NbtOps.INSTANCE));
        zombievillager.setTradeOffers(villager.getOffers());
        zombievillager.setVillagerXp(villager.getVillagerXp());
        EventHooks.onLivingConvert((LivingEntity)villager, (LivingEntity)zombievillager);
    }
}

