/*
 * Decompiled with CFR 0.152.
 */
package alexthw.eidolon_repraised.common.spell;

import alexthw.eidolon_repraised.Eidolon;
import alexthw.eidolon_repraised.api.capability.IMana;
import alexthw.eidolon_repraised.api.capability.IReputation;
import alexthw.eidolon_repraised.api.spells.Sign;
import alexthw.eidolon_repraised.common.deity.Deities;
import alexthw.eidolon_repraised.common.spell.DarkTouchSpell;
import alexthw.eidolon_repraised.recipe.ChantConversionRecipe;
import alexthw.eidolon_repraised.registries.EidolonCapabilities;
import alexthw.eidolon_repraised.registries.EidolonDataComponents;
import alexthw.eidolon_repraised.registries.EidolonRecipes;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;

public class LightTouchSpell
extends DarkTouchSpell {
    public LightTouchSpell(ResourceLocation name, Sign ... signs) {
        super(name, signs);
        NeoForge.EVENT_BUS.addListener(LightTouchSpell::onHurt);
    }

    @SubscribeEvent
    public static void onHurt(LivingDamageEvent.Pre event) {
        Entity entity = event.getSource().getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity caster = (LivingEntity)entity;
            if (Eidolon.isValidUndead(event.getEntity())) {
                ItemStack weapon = caster.getMainHandItem();
                if (weapon.isEmpty()) {
                    return;
                }
                if (weapon.has((DataComponentType)EidolonDataComponents.CONSECRATED.get()) && (Integer)weapon.getOrDefault((DataComponentType)EidolonDataComponents.CONSECRATED.get(), (Object)0) > 0) {
                    event.setNewDamage(event.getNewDamage() * 1.5f);
                    weapon.set(EidolonDataComponents.CONSECRATED, (Object)((Integer)weapon.getOrDefault((DataComponentType)EidolonDataComponents.CONSECRATED.get(), (Object)1) - 1));
                }
            }
        }
    }

    @Override
    public boolean canCast(Level world, BlockPos pos, Player player) {
        IReputation reputation = (IReputation)player.getCapability(EidolonCapabilities.REPUTATION_CAPABILITY);
        if (reputation == null) {
            return false;
        }
        if (reputation.getReputation(Deities.LIGHT_DEITY.getId()) < 10.0) {
            player.displayClientMessage((Component)Component.translatable((String)"eidolon_repraised.message.not_enough_reputation"), true);
            return false;
        }
        Vec3 v = LightTouchSpell.getVector(world, player);
        List items = world.getEntitiesOfClass(ItemEntity.class, new AABB(v.x - 1.5, v.y - 1.5, v.z - 1.5, v.x + 1.5, v.y + 1.5, v.z + 1.5));
        if (items.size() != 1) {
            return false;
        }
        ItemStack stack = ((ItemEntity)items.getFirst()).getItem();
        return this.canTouch(stack, world, player);
    }

    @Override
    boolean canTouch(ItemStack stack, Level world, Player player) {
        if (stack.isDamageableItem() && stack.getMaxStackSize() == 1) {
            return true;
        }
        List conversions = world.getRecipeManager().getAllRecipesFor((RecipeType)EidolonRecipes.CHANT_CONVERSION_TYPE.get());
        IReputation reputation = (IReputation)player.getCapability(EidolonCapabilities.REPUTATION_CAPABILITY);
        if (reputation == null) {
            return false;
        }
        double lightRep = reputation.getReputation(Deities.LIGHT_DEITY_ID);
        return conversions.stream().map(RecipeHolder::value).filter(r -> r.input.test(stack) && (Deities.DUMMY_ID.equals((Object)r.deity) || Deities.LIGHT_DEITY_ID.equals((Object)r.deity))).anyMatch(r -> lightRep >= (double)r.minDevotion);
    }

    @Override
    protected ItemStack touchResult(ItemStack stack, Player player) {
        IReputation reputation = (IReputation)player.getCapability(EidolonCapabilities.REPUTATION_CAPABILITY);
        IMana mana = (IMana)player.getCapability(EidolonCapabilities.MANA_CAPABILITY);
        if (reputation != null && mana != null) {
            double lightRep = reputation.getReputation(Deities.LIGHT_DEITY_ID);
            for (RecipeHolder holder : player.level().getRecipeManager().getAllRecipesFor((RecipeType)EidolonRecipes.CHANT_CONVERSION_TYPE.get())) {
                int maxConversionCount;
                ChantConversionRecipe r = (ChantConversionRecipe)holder.value();
                if (!r.input.test(stack) || !Deities.DUMMY_ID.equals((Object)r.deity) && !Deities.LIGHT_DEITY_ID.equals((Object)r.deity) || !(lightRep >= (double)r.minDevotion)) continue;
                float conversionCost = r.conversionCost >= 0.0f ? r.conversionCost : (float)this.getCost();
                int n = maxConversionCount = conversionCost != 0.0f ? (int)Math.min((float)stack.getCount(), mana.getMagic() / conversionCost) : stack.getCount();
                if (maxConversionCount <= 0) continue;
                IMana.expendMana(player, (int)(conversionCost * (float)maxConversionCount));
                ItemStack result = r.getResultItem((HolderLookup.Provider)player.level().registryAccess());
                result.setCount(maxConversionCount);
                return result;
            }
        }
        if (stack.getMaxStackSize() == 1 && stack.isDamageableItem()) {
            IMana.expendMana(player, this.getCost());
            stack.set(EidolonDataComponents.CONSECRATED, (Object)50);
        }
        return stack;
    }
}

